/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import io.asyncer.r2dbc.mysql.message.server.EofMessage;
import io.asyncer.r2dbc.mysql.message.server.MetadataDecodeContext;
import io.asyncer.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.util.annotation.Nullable;

final class PreparedMetadataDecodeContext
extends MetadataDecodeContext {
    private final DefinitionMetadataMessage[] paramMetadata;
    private final DefinitionMetadataMessage[] colMetadata;
    private final AtomicInteger columns = new AtomicInteger();
    private volatile boolean inMetadata = true;

    PreparedMetadataDecodeContext(boolean eofDeprecated, int totalColumns, int totalParameters) {
        super(eofDeprecated);
        this.paramMetadata = PreparedMetadataDecodeContext.createArray(totalParameters);
        this.colMetadata = PreparedMetadataDecodeContext.createArray(totalColumns);
    }

    public String toString() {
        return "DecodeContext-PreparedMetadata";
    }

    @Override
    boolean isInMetadata() {
        return this.inMetadata;
    }

    @Override
    protected SyntheticMetadataMessage checkComplete(int index, @Nullable EofMessage eof) {
        if (index == this.paramMetadata.length) {
            if (this.colMetadata.length == 0) {
                this.inMetadata = false;
                return new SyntheticMetadataMessage(true, this.paramMetadata, eof);
            }
            return new SyntheticMetadataMessage(false, this.paramMetadata, eof);
        }
        if (index == this.paramMetadata.length + this.colMetadata.length) {
            this.inMetadata = false;
            return new SyntheticMetadataMessage(true, this.colMetadata, eof);
        }
        return null;
    }

    @Override
    protected int putMetadata(DefinitionMetadataMessage metadata) {
        int colSize;
        int paramSize;
        int index = this.columns.getAndIncrement();
        if (index >= (paramSize = this.paramMetadata.length) + (colSize = this.colMetadata.length)) {
            throw new IllegalStateException("Columns metadata has filled up, now index: " + index + ", param length: " + paramSize + ", column length: " + colSize);
        }
        if (index < paramSize) {
            this.paramMetadata[index] = metadata;
        } else {
            this.colMetadata[index - paramSize] = metadata;
        }
        return index + 1;
    }

    @Override
    protected int currentIndex() {
        return this.columns.get();
    }

    @Override
    protected Object loggingPoints() {
        int paramSize = this.paramMetadata.length;
        return "[" + paramSize + ", " + (paramSize + this.colMetadata.length) + ']';
    }

    private static DefinitionMetadataMessage[] createArray(int size) {
        return size == 0 ? SyntheticMetadataMessage.EMPTY_METADATA : new DefinitionMetadataMessage[size];
    }
}

