/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlConnectionConfiguration;
import io.asyncer.r2dbc.mysql.MySqlConnectionFactory;
import io.asyncer.r2dbc.mysql.OptionMapper;
import io.asyncer.r2dbc.mysql.constant.SslMode;
import io.asyncer.r2dbc.mysql.constant.ZeroDateOption;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.ConnectionFactoryProvider;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.time.ZoneId;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;

public final class MySqlConnectionFactoryProvider
implements ConnectionFactoryProvider {
    public static final String MYSQL_DRIVER = "mysql";
    public static final Option<String> UNIX_SOCKET = Option.valueOf((String)"unixSocket");
    public static final Option<ZoneId> SERVER_ZONE_ID = Option.valueOf((String)"serverZoneId");
    public static final Option<ZeroDateOption> ZERO_DATE = Option.valueOf((String)"zeroDate");
    public static final Option<SslMode> SSL_MODE = Option.valueOf((String)"sslMode");
    public static final Option<HostnameVerifier> SSL_HOSTNAME_VERIFIER = Option.valueOf((String)"sslHostnameVerifier");
    public static final Option<String[]> TLS_VERSION = Option.valueOf((String)"tlsVersion");
    public static final Option<String> SSL_CA = Option.valueOf((String)"sslCa");
    public static final Option<String> SSL_KEY = Option.valueOf((String)"sslKey");
    public static final Option<CharSequence> SSL_KEY_PASSWORD = Option.sensitiveValueOf((String)"sslKeyPassword");
    public static final Option<String> SSL_CERT = Option.valueOf((String)"sslCert");
    public static final Option<Function<SslContextBuilder, SslContextBuilder>> SSL_CONTEXT_BUILDER_CUSTOMIZER = Option.valueOf((String)"sslContextBuilderCustomizer");
    @Deprecated
    public static final Option<Duration> SOCKET_TIMEOUT = Option.valueOf((String)"socketTimeout");
    public static final Option<Boolean> TCP_KEEP_ALIVE = Option.valueOf((String)"tcpKeepAlive");
    public static final Option<Boolean> TCP_NO_DELAY = Option.valueOf((String)"tcpNoDelay");
    public static final Option<Object> USE_SERVER_PREPARE_STATEMENT = Option.valueOf((String)"useServerPrepareStatement");
    public static final Option<Integer> PREPARE_CACHE_SIZE = Option.valueOf((String)"prepareCacheSize");
    public static final Option<Integer> QUERY_CACHE_SIZE = Option.valueOf((String)"queryCacheSize");
    public static final Option<Boolean> AUTODETECT_EXTENSIONS = Option.valueOf((String)"autodetectExtensions");

    public ConnectionFactory create(ConnectionFactoryOptions options) {
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        return MySqlConnectionFactory.from(MySqlConnectionFactoryProvider.setup(options));
    }

    public boolean supports(ConnectionFactoryOptions options) {
        AssertUtils.requireNonNull(options, "connectionFactoryOptions must not be null");
        return MYSQL_DRIVER.equals(options.getValue(ConnectionFactoryOptions.DRIVER));
    }

    public String getDriver() {
        return MYSQL_DRIVER;
    }

    static MySqlConnectionConfiguration setup(ConnectionFactoryOptions options) {
        OptionMapper mapper = new OptionMapper(options);
        MySqlConnectionConfiguration.Builder builder = MySqlConnectionConfiguration.builder();
        mapper.requires(ConnectionFactoryOptions.USER).asString().to(builder::user);
        mapper.optional(ConnectionFactoryOptions.PASSWORD).asPassword().to(builder::password);
        mapper.optional(UNIX_SOCKET).asString().to(builder::unixSocket).otherwise(() -> MySqlConnectionFactoryProvider.setupHost(builder, mapper));
        mapper.optional(SERVER_ZONE_ID).as(ZoneId.class, id -> ZoneId.of(id, ZoneId.SHORT_IDS)).to(builder::serverZoneId);
        mapper.optional(TCP_KEEP_ALIVE).asBoolean().to(builder::tcpKeepAlive);
        mapper.optional(TCP_NO_DELAY).asBoolean().to(builder::tcpNoDelay);
        mapper.optional(ZERO_DATE).as(ZeroDateOption.class, id -> ZeroDateOption.valueOf(id.toUpperCase())).to(builder::zeroDateOption);
        mapper.optional(USE_SERVER_PREPARE_STATEMENT).prepare(builder::useClientPrepareStatement, builder::useServerPrepareStatement, builder::useServerPrepareStatement);
        mapper.optional(QUERY_CACHE_SIZE).asInt().to(builder::queryCacheSize);
        mapper.optional(PREPARE_CACHE_SIZE).asInt().to(builder::prepareCacheSize);
        mapper.optional(AUTODETECT_EXTENSIONS).asBoolean().to(builder::autodetectExtensions);
        mapper.optional(ConnectionFactoryOptions.CONNECT_TIMEOUT).as(Duration.class, Duration::parse).to(builder::connectTimeout);
        mapper.optional(SOCKET_TIMEOUT).as(Duration.class, Duration::parse).to(builder::socketTimeout);
        mapper.optional(ConnectionFactoryOptions.DATABASE).asString().to(builder::database);
        return builder.build();
    }

    private static void setupHost(MySqlConnectionConfiguration.Builder builder, OptionMapper mapper) {
        mapper.requires(ConnectionFactoryOptions.HOST).asString().to(builder::host);
        mapper.optional(ConnectionFactoryOptions.PORT).asInt().to(builder::port);
        mapper.optional(ConnectionFactoryOptions.SSL).asBoolean().to(isSsl -> builder.sslMode(isSsl != false ? SslMode.REQUIRED : SslMode.DISABLED));
        mapper.optional(SSL_MODE).as(SslMode.class, id -> SslMode.valueOf(id.toUpperCase())).to(builder::sslMode);
        mapper.optional(TLS_VERSION).asStrings().to(builder::tlsVersion);
        mapper.optional(SSL_HOSTNAME_VERIFIER).as(HostnameVerifier.class).to(builder::sslHostnameVerifier);
        mapper.optional(SSL_CERT).asString().to(builder::sslCert);
        mapper.optional(SSL_KEY).asString().to(builder::sslKey);
        mapper.optional(SSL_KEY_PASSWORD).asPassword().to(builder::sslKeyPassword);
        mapper.optional(SSL_CONTEXT_BUILDER_CUSTOMIZER).as(Function.class).to(builder::sslContextBuilderCustomizer);
        mapper.optional(SSL_CA).asString().to(builder::sslCa);
    }
}

