/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlColumnDescriptor;
import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlRowMetadata;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import io.asyncer.r2dbc.mysql.util.AssertUtils;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.lang.reflect.ParameterizedType;
import reactor.util.annotation.Nullable;

public final class MySqlRow
implements Row {
    private final FieldValue[] fields;
    private final MySqlRowMetadata rowMetadata;
    private final Codecs codecs;
    private final boolean binary;
    private final ConnectionContext context;

    MySqlRow(FieldValue[] fields, MySqlRowMetadata rowMetadata, Codecs codecs, boolean binary, ConnectionContext context) {
        this.fields = AssertUtils.requireNonNull(fields, "fields must not be null");
        this.rowMetadata = AssertUtils.requireNonNull(rowMetadata, "rowMetadata must not be null");
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.binary = binary;
        this.context = AssertUtils.requireNonNull(context, "context must not be null");
    }

    public <T> T get(int index, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(index);
        return this.codecs.decode(this.fields[index], (MySqlColumnMetadata)info, type, this.binary, (CodecContext)this.context);
    }

    public <T> T get(String name, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(name);
        return this.codecs.decode(this.fields[info.getIndex()], (MySqlColumnMetadata)info, type, this.binary, (CodecContext)this.context);
    }

    @Nullable
    public <T> T get(int index, ParameterizedType type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(index);
        return this.codecs.decode(this.fields[index], (MySqlColumnMetadata)info, type, this.binary, (CodecContext)this.context);
    }

    @Nullable
    public <T> T get(String name, ParameterizedType type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        MySqlColumnDescriptor info = this.rowMetadata.getColumnMetadata(name);
        return this.codecs.decode(this.fields[info.getIndex()], (MySqlColumnMetadata)info, type, this.binary, (CodecContext)this.context);
    }

    public RowMetadata getMetadata() {
        return this.rowMetadata;
    }
}

