/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import reactor.util.annotation.Nullable;

final class CodecUtils {
    private static final String LONG_MAX_VALUE = Long.toString(Long.MAX_VALUE);

    @Nullable
    static Class<?> getTypeArgument(ParameterizedType type, Class<?> rawClass) {
        Type[] arguments = type.getActualTypeArguments();
        if (arguments.length != 1) {
            return null;
        }
        Type result = arguments[0];
        return type.getRawType() == rawClass && result instanceof Class ? (Class)result : null;
    }

    static ByteBuf encodeAscii(ByteBufAllocator alloc, String ascii) {
        int size = ascii.length();
        if (size == 0) {
            return alloc.buffer(1).writeByte(0);
        }
        ByteBuf buf = alloc.buffer(VarIntUtils.varIntBytes(size) + size);
        try {
            VarIntUtils.writeVarInt(buf, size);
            buf.writeCharSequence((CharSequence)ascii, StandardCharsets.US_ASCII);
            return buf;
        }
        catch (Throwable e) {
            buf.release();
            throw e;
        }
    }

    static BigInteger unsignedBigInteger(long num) {
        byte[] bits = new byte[]{0, (byte)(num >>> 56), (byte)(num >>> 48), (byte)(num >>> 40), (byte)(num >>> 32), (byte)(num >>> 24), (byte)(num >>> 16), (byte)(num >>> 8), (byte)num};
        return new BigInteger(bits);
    }

    static long parsePositive(String num) {
        long value = 0L;
        int size = num.length();
        for (int i = 0; i < size; ++i) {
            value = value * 10L + (long)(num.charAt(i) - 48);
        }
        return value;
    }

    static boolean isGreaterThanLongMax(String num) {
        int maxLength;
        int length = num.length();
        if (length != (maxLength = LONG_MAX_VALUE.length())) {
            return length > maxLength;
        }
        return num.compareTo(LONG_MAX_VALUE) > 0;
    }

    static int parseInt(ByteBuf buf) {
        int value;
        boolean isNegative;
        byte first = buf.readByte();
        if (first == 45) {
            isNegative = true;
            value = 0;
        } else if (first >= 48 && first <= 57) {
            isNegative = false;
            value = first - 48;
        } else {
            isNegative = false;
            value = 0;
        }
        while (buf.isReadable()) {
            value = value * 10 + (buf.readByte() - 48);
        }
        return isNegative ? -value : value;
    }

    static long parseLong(ByteBuf buf) {
        long value;
        boolean isNegative;
        byte first = buf.readByte();
        if (first == 45) {
            isNegative = true;
            value = 0L;
        } else if (first >= 48 && first <= 57) {
            isNegative = false;
            value = (long)first - 48L;
        } else {
            isNegative = false;
            value = 0L;
        }
        while (buf.isReadable()) {
            value = value * 10L + (long)(buf.readByte() - 48);
        }
        return isNegative ? -value : value;
    }

    private CodecUtils() {
    }
}

