/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ColumnNameSet;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

final class InsertSyntheticRow
implements Row,
RowMetadata,
ColumnMetadata {
    private final Codecs codecs;
    private final String keyName;
    private final long lastInsertId;
    private final ColumnNameSet nameSet;

    InsertSyntheticRow(Codecs codecs, String keyName, long lastInsertId) {
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        this.keyName = AssertUtils.requireNonNull(keyName, "keyName must not be null");
        this.lastInsertId = lastInsertId;
        this.nameSet = ColumnNameSet.of(keyName);
    }

    public <T> T get(int index, Class<T> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        InsertSyntheticRow.assertValidIndex(index);
        return this.get0(type);
    }

    public <T> T get(String name, Class<T> type) {
        AssertUtils.requireNonNull(name, "name must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        this.assertValidName(name);
        return this.get0(type);
    }

    public Number get(int index) {
        InsertSyntheticRow.assertValidIndex(index);
        return (Number)this.get0(this.getType().getJavaType());
    }

    public Number get(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        this.assertValidName(name);
        return (Number)this.get0(this.getType().getJavaType());
    }

    public boolean contains(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        return this.contains0(name);
    }

    public RowMetadata getMetadata() {
        return this;
    }

    public ColumnMetadata getColumnMetadata(int index) {
        InsertSyntheticRow.assertValidIndex(index);
        return this;
    }

    public ColumnMetadata getColumnMetadata(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        this.assertValidName(name);
        return this;
    }

    public List<ColumnMetadata> getColumnMetadatas() {
        return Collections.singletonList(this);
    }

    public MySqlType getType() {
        return this.lastInsertId < 0L ? MySqlType.BIGINT_UNSIGNED : MySqlType.BIGINT;
    }

    public String getName() {
        return this.keyName;
    }

    public Class<?> getJavaType() {
        return this.getType().getJavaType();
    }

    public Nullability getNullability() {
        return Nullability.NON_NULL;
    }

    private void assertValidName(String name) {
        if (!this.contains0(name)) {
            throw new NoSuchElementException("Column name '" + name + "' does not exist in " + this.nameSet);
        }
    }

    private boolean contains0(String name) {
        return this.nameSet.contains(name);
    }

    private <T> T get0(Class<?> type) {
        return this.codecs.decodeLastInsertId(this.lastInsertId, type);
    }

    private static void assertValidIndex(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", total: 1");
        }
    }
}

