/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.authentication;

import io.asyncer.r2dbc.mysql.authentication.AuthUtils;
import io.asyncer.r2dbc.mysql.authentication.CachingSha2FullAuthProvider;
import io.asyncer.r2dbc.mysql.authentication.MySqlAuthProvider;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import org.jetbrains.annotations.Nullable;

final class CachingSha2FastAuthProvider
implements MySqlAuthProvider {
    private static final String ALGORITHM = "SHA-256";
    private static final boolean IS_LEFT_SALT = false;

    static CachingSha2FastAuthProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    @Override
    public boolean isSslNecessary() {
        return false;
    }

    @Override
    public byte[] authentication(@Nullable CharSequence password, byte[] salt, CharCollation collation) {
        if (password == null || password.length() <= 0) {
            return new byte[]{0};
        }
        AssertUtils.requireNonNull(salt, "salt must not be null when password exists");
        AssertUtils.requireNonNull(collation, "collation must not be null when password exists");
        return AuthUtils.hash(ALGORITHM, false, password, salt, collation.getCharset());
    }

    @Override
    public MySqlAuthProvider next() {
        return CachingSha2FullAuthProvider.INSTANCE;
    }

    @Override
    public String getType() {
        return "caching_sha2_password";
    }

    private CachingSha2FastAuthProvider() {
    }

    private static class LazyHolder {
        private static final CachingSha2FastAuthProvider INSTANCE = new CachingSha2FastAuthProvider();

        private LazyHolder() {
        }
    }
}

