/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.message.client.ParamWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class PreparedTextQueryMessage
extends AtomicReference<MySqlParameter[]>
implements ClientMessage,
Disposable {
    private final Query query;

    public PreparedTextQueryMessage(Query query, MySqlParameter[] values) {
        super(AssertUtils.requireNonNull(values, "values must not be null"));
        this.query = AssertUtils.requireNonNull(query, "query must not be null");
    }

    public void dispose() {
        MySqlParameter[] values;
        for (MySqlParameter value : values = (MySqlParameter[])this.getAndSet(null)) {
            if (value == null) continue;
            value.dispose();
        }
    }

    public boolean isDisposed() {
        return this.get() == null;
    }

    public Mono<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        Charset charset = context.getClientCollation().getCharset();
        Flux parameters = Flux.defer(() -> {
            Object[] values = this.getAndSet(null);
            if (values == null) {
                return Flux.error((Throwable)new IllegalStateException("Parameters have been disposed"));
            }
            return Flux.fromArray((Object[])values);
        });
        return ParamWriter.publish(this.query, (Flux<MySqlParameter>)parameters).map(it -> {
            ByteBuf buf = allocator.buffer();
            try {
                buf.writeByte(3).writeCharSequence((CharSequence)it, charset);
                return buf;
            }
            catch (Throwable e) {
                buf.release();
                throw e;
            }
        });
    }

    @Override
    public String toString() {
        return "PreparedTextQueryMessage{sql=REDACTED}";
    }
}

