/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

final class QueryLogger {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance((String)"io.asyncer.r2dbc.mysql.QUERY");

    static void log(String query) {
        logger.debug("Executing statement [{}]", (Object)query);
    }

    static void log(int statementId, String query) {
        logger.debug("Prepared statement {} [{}]", (Object)statementId, (Object)query);
    }

    static void log(Query query, String returning, MySqlParameter[] values) {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing statement [{}] with {}", (Object)StringUtils.extendReturning(query.getFormattedSql(), returning), (Object)values);
        }
    }

    static void log(int statementId, MySqlParameter[] values) {
        logger.debug("Executing prepared statement {} with {}", (Object)statementId, (Object)values);
    }

    static void logLocalInfile(String path) {
        logger.debug("Loading data from: {}", (Object)path);
    }

    private QueryLogger() {
    }
}

