/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.codec.PrimitiveCodec;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;

abstract class AbstractPrimitiveCodec<T>
implements PrimitiveCodec<T> {
    private final Class<T> primitiveClass;
    private final Class<T> boxedClass;

    AbstractPrimitiveCodec(Class<T> primitiveClass, Class<T> boxedClass) {
        AssertUtils.require(primitiveClass.isPrimitive() && !boxedClass.isPrimitive(), "primitiveClass must be primitive and boxedClass must not be primitive");
        this.primitiveClass = primitiveClass;
        this.boxedClass = boxedClass;
    }

    @Override
    public final boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        return target.isAssignableFrom(this.boxedClass) && this.canPrimitiveDecode(metadata);
    }

    @Override
    public final Class<T> getPrimitiveClass() {
        return this.primitiveClass;
    }
}

