/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.codec.LongCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class BigIntegerCodec
extends AbstractClassedCodec<BigInteger> {
    static final BigIntegerCodec INSTANCE = new BigIntegerCodec();

    private BigIntegerCodec() {
        super(BigInteger.class);
    }

    @Override
    public BigInteger decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        MySqlType type = metadata.getType();
        if (binary) {
            return BigIntegerCodec.decodeBinary(value, type);
        }
        switch (type) {
            case FLOAT: {
                return BigDecimal.valueOf(Float.parseFloat(value.toString(StandardCharsets.US_ASCII))).toBigInteger();
            }
            case DOUBLE: {
                return BigDecimal.valueOf(Double.parseDouble(value.toString(StandardCharsets.US_ASCII))).toBigInteger();
            }
            case DECIMAL: {
                return BigIntegerCodec.decimalBigInteger(value);
            }
            case BIGINT_UNSIGNED: {
                String num;
                if (value.getByte(value.readerIndex()) == 43) {
                    value.skipBytes(1);
                }
                if (CodecUtils.isGreaterThanLongMax(num = value.toString(StandardCharsets.US_ASCII))) {
                    return new BigInteger(num);
                }
                return BigInteger.valueOf(CodecUtils.parsePositive(num));
            }
        }
        return BigInteger.valueOf(CodecUtils.parseLong(value));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BigInteger;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        BigInteger i = (BigInteger)value;
        if (i.bitLength() < 64) {
            return LongCodec.encodeLong(i.longValue());
        }
        return new BigIntegerMySqlParameter((BigInteger)value);
    }

    @Override
    protected boolean doCanDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    private static BigInteger decodeBinary(ByteBuf buf, MySqlType type) {
        switch (type) {
            case BIGINT_UNSIGNED: {
                long v = buf.readLongLE();
                if (v < 0L) {
                    return CodecUtils.unsignedBigInteger(v);
                }
                return BigInteger.valueOf(v);
            }
            case BIGINT: {
                return BigInteger.valueOf(buf.readLongLE());
            }
            case INT_UNSIGNED: {
                return BigInteger.valueOf(buf.readUnsignedIntLE());
            }
            case INT: 
            case MEDIUMINT_UNSIGNED: 
            case MEDIUMINT: {
                return BigInteger.valueOf(buf.readIntLE());
            }
            case SMALLINT_UNSIGNED: {
                return BigInteger.valueOf(buf.readUnsignedShortLE());
            }
            case SMALLINT: 
            case YEAR: {
                return BigInteger.valueOf(buf.readShortLE());
            }
            case TINYINT_UNSIGNED: {
                return BigInteger.valueOf(buf.readUnsignedByte());
            }
            case TINYINT: {
                return BigInteger.valueOf(buf.readByte());
            }
            case DECIMAL: {
                return BigIntegerCodec.decimalBigInteger(buf);
            }
            case FLOAT: {
                return BigDecimal.valueOf(buf.readFloatLE()).toBigInteger();
            }
            case DOUBLE: {
                return BigDecimal.valueOf(buf.readDoubleLE()).toBigInteger();
            }
        }
        throw new IllegalStateException("Cannot decode type " + (Object)((Object)type) + " as a BigInteger");
    }

    private static BigInteger decimalBigInteger(ByteBuf buf) {
        return new BigDecimal(buf.toString(StandardCharsets.US_ASCII)).toBigInteger();
    }

    private static class BigIntegerMySqlParameter
    extends AbstractMySqlParameter {
        private final BigInteger value;

        private BigIntegerMySqlParameter(BigInteger value) {
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> CodecUtils.encodeAscii(allocator, this.value.toString()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeBigInteger(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARCHAR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BigIntegerMySqlParameter)) {
                return false;
            }
            BigIntegerMySqlParameter that = (BigIntegerMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

