/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.codec.BigDecimalCodec;
import io.asyncer.r2dbc.mysql.codec.BigIntegerCodec;
import io.asyncer.r2dbc.mysql.codec.BitSetCodec;
import io.asyncer.r2dbc.mysql.codec.BlobCodec;
import io.asyncer.r2dbc.mysql.codec.BooleanCodec;
import io.asyncer.r2dbc.mysql.codec.ByteArrayCodec;
import io.asyncer.r2dbc.mysql.codec.ByteBufferCodec;
import io.asyncer.r2dbc.mysql.codec.ByteCodec;
import io.asyncer.r2dbc.mysql.codec.ClobCodec;
import io.asyncer.r2dbc.mysql.codec.Codec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.codec.CodecsBuilder;
import io.asyncer.r2dbc.mysql.codec.DoubleCodec;
import io.asyncer.r2dbc.mysql.codec.DurationCodec;
import io.asyncer.r2dbc.mysql.codec.EnumCodec;
import io.asyncer.r2dbc.mysql.codec.FloatCodec;
import io.asyncer.r2dbc.mysql.codec.InstantCodec;
import io.asyncer.r2dbc.mysql.codec.IntegerCodec;
import io.asyncer.r2dbc.mysql.codec.LocalDateCodec;
import io.asyncer.r2dbc.mysql.codec.LocalDateTimeCodec;
import io.asyncer.r2dbc.mysql.codec.LocalTimeCodec;
import io.asyncer.r2dbc.mysql.codec.LongCodec;
import io.asyncer.r2dbc.mysql.codec.MassiveCodec;
import io.asyncer.r2dbc.mysql.codec.MassiveParametrizedCodec;
import io.asyncer.r2dbc.mysql.codec.NullMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.OffsetDateTimeCodec;
import io.asyncer.r2dbc.mysql.codec.OffsetTimeCodec;
import io.asyncer.r2dbc.mysql.codec.ParametrizedCodec;
import io.asyncer.r2dbc.mysql.codec.PrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.SetCodec;
import io.asyncer.r2dbc.mysql.codec.ShortCodec;
import io.asyncer.r2dbc.mysql.codec.StringCodec;
import io.asyncer.r2dbc.mysql.codec.YearCodec;
import io.asyncer.r2dbc.mysql.codec.ZonedDateTimeCodec;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import io.asyncer.r2dbc.mysql.message.LargeFieldValue;
import io.asyncer.r2dbc.mysql.message.NormalFieldValue;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.Nullable;

final class DefaultCodecs
implements Codecs {
    private final Codec<?>[] codecs;
    private final ParametrizedCodec<?>[] parametrizedCodecs;
    private final MassiveCodec<?>[] massiveCodecs;
    private final MassiveParametrizedCodec<?>[] massiveParametrizedCodecs;
    private final Map<Type, PrimitiveCodec<?>> primitiveCodecs;

    private DefaultCodecs(Codec<?>[] codecs) {
        this.codecs = AssertUtils.requireNonNull(codecs, "codecs must not be null");
        HashMap primitiveCodecs = new HashMap();
        ArrayList<ParametrizedCodec> parametrizedCodecs = new ArrayList<ParametrizedCodec>();
        ArrayList<MassiveCodec> massiveCodecs = new ArrayList<MassiveCodec>();
        ArrayList<MassiveParametrizedCodec> massiveParamCodecs = new ArrayList<MassiveParametrizedCodec>();
        for (Codec<?> codec : codecs) {
            if (codec instanceof PrimitiveCodec) {
                PrimitiveCodec c = (PrimitiveCodec)codec;
                primitiveCodecs.put(c.getPrimitiveClass(), c);
            } else if (codec instanceof ParametrizedCodec) {
                parametrizedCodecs.add((ParametrizedCodec)codec);
            }
            if (!(codec instanceof MassiveCodec)) continue;
            massiveCodecs.add((MassiveCodec)codec);
            if (!(codec instanceof MassiveParametrizedCodec)) continue;
            massiveParamCodecs.add((MassiveParametrizedCodec)codec);
        }
        this.primitiveCodecs = primitiveCodecs;
        this.massiveCodecs = massiveCodecs.toArray(new MassiveCodec[0]);
        this.massiveParametrizedCodecs = massiveParamCodecs.toArray(new MassiveParametrizedCodec[0]);
        this.parametrizedCodecs = parametrizedCodecs.toArray(new ParametrizedCodec[0]);
    }

    @Override
    public <T> T decode(FieldValue value, MySqlColumnMetadata metadata, Class<?> type, boolean binary, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(metadata, "info must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        if (value.isNull()) {
            return null;
        }
        Class<?> target = DefaultCodecs.chooseClass(metadata, type);
        if (target.isPrimitive()) {
            return this.decodePrimitive(value, metadata, target, binary, context);
        }
        if (value instanceof NormalFieldValue) {
            return this.decodeNormal((NormalFieldValue)value, metadata, target, binary, context);
        }
        if (value instanceof LargeFieldValue) {
            return this.decodeMassive((LargeFieldValue)value, metadata, target, binary, context);
        }
        throw new IllegalArgumentException("Unknown value " + value.getClass().getSimpleName());
    }

    @Override
    public <T> T decode(FieldValue value, MySqlColumnMetadata metadata, ParameterizedType type, boolean binary, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(metadata, "info must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        AssertUtils.requireNonNull(type, "type must not be null");
        if (value.isNull()) {
            return null;
        }
        if (value instanceof NormalFieldValue) {
            return this.decodeNormal((NormalFieldValue)value, metadata, type, binary, context);
        }
        if (value instanceof LargeFieldValue) {
            return this.decodeMassive((LargeFieldValue)value, metadata, type, binary, context);
        }
        throw new IllegalArgumentException("Unknown value " + value.getClass().getSimpleName());
    }

    @Override
    public <T> T decodeLastInsertId(long value, Class<?> type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        if (Byte.TYPE == type || Byte.class == type) {
            return (T)Byte.valueOf((byte)value);
        }
        if (Short.TYPE == type || Short.class == type) {
            return (T)Short.valueOf((short)value);
        }
        if (Integer.TYPE == type || Integer.class == type) {
            return (T)Integer.valueOf((int)value);
        }
        if (Long.TYPE == type || Long.class == type) {
            return (T)Long.valueOf(value);
        }
        if (BigInteger.class == type) {
            if (value < 0L) {
                return (T)CodecUtils.unsignedBigInteger(value);
            }
            return (T)BigInteger.valueOf(value);
        }
        if (type.isAssignableFrom(Number.class)) {
            if (value < 0L) {
                return (T)CodecUtils.unsignedBigInteger(value);
            }
            return (T)Long.valueOf(value);
        }
        throw new IllegalArgumentException(String.format("Cannot decode %s with last inserted ID %s", type, value < 0L ? Long.toUnsignedString(value) : Long.valueOf(value)));
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        AssertUtils.requireNonNull(value, "value must not be null");
        AssertUtils.requireNonNull(context, "context must not be null");
        Object valueToEncode = DefaultCodecs.getValueToEncode(value);
        if (null == valueToEncode) {
            return this.encodeNull();
        }
        for (Codec<?> codec : this.codecs) {
            if (!codec.canEncode(valueToEncode)) continue;
            return codec.encode(valueToEncode, context);
        }
        throw new IllegalArgumentException("Cannot encode " + valueToEncode.getClass());
    }

    @Nullable
    private static Object getValueToEncode(Object value) {
        if (value instanceof Parameter) {
            return ((Parameter)value).getValue();
        }
        return value;
    }

    @Override
    public MySqlParameter encodeNull() {
        return NullMySqlParameter.INSTANCE;
    }

    @Nullable
    private <T> T decodePrimitive(FieldValue value, MySqlColumnMetadata metadata, Class<?> type, boolean binary, CodecContext context) {
        PrimitiveCodec<?> codec = this.primitiveCodecs.get(type);
        if (codec != null && value instanceof NormalFieldValue && codec.canPrimitiveDecode(metadata)) {
            return (T)codec.decode(((NormalFieldValue)value).getBufferSlice(), metadata, type, binary, context);
        }
        throw new IllegalArgumentException("Cannot decode " + value.getClass().getSimpleName() + " of " + type + " for " + (Object)((Object)metadata.getType()));
    }

    @Nullable
    private <T> T decodeNormal(NormalFieldValue value, MySqlColumnMetadata metadata, Class<?> type, boolean binary, CodecContext context) {
        for (Codec<?> codec : this.codecs) {
            if (!codec.canDecode(metadata, type)) continue;
            Codec<?> c = codec;
            return (T)c.decode(value.getBufferSlice(), metadata, type, binary, context);
        }
        throw new IllegalArgumentException("Cannot decode " + type + " for " + (Object)((Object)metadata.getType()));
    }

    @Nullable
    private <T> T decodeNormal(NormalFieldValue value, MySqlColumnMetadata metadata, ParameterizedType type, boolean binary, CodecContext context) {
        for (ParametrizedCodec<?> codec : this.parametrizedCodecs) {
            if (!codec.canDecode(metadata, type)) continue;
            Object result = codec.decode(value.getBufferSlice(), metadata, type, binary, context);
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot decode " + type + " for " + (Object)((Object)metadata.getType()));
    }

    @Nullable
    private <T> T decodeMassive(LargeFieldValue value, MySqlColumnMetadata metadata, Class<?> type, boolean binary, CodecContext context) {
        for (MassiveCodec<?> codec : this.massiveCodecs) {
            if (!codec.canDecode(metadata, type)) continue;
            MassiveCodec<?> c = codec;
            return (T)c.decodeMassive(value.getBufferSlices(), metadata, type, binary, context);
        }
        throw new IllegalArgumentException("Cannot decode massive " + type + " for " + (Object)((Object)metadata.getType()));
    }

    @Nullable
    private <T> T decodeMassive(LargeFieldValue value, MySqlColumnMetadata metadata, ParameterizedType type, boolean binary, CodecContext context) {
        for (MassiveParametrizedCodec<?> codec : this.massiveParametrizedCodecs) {
            if (!codec.canDecode(metadata, type)) continue;
            Object result = codec.decodeMassive(value.getBufferSlices(), metadata, type, binary, context);
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot decode massive  " + type + " for " + (Object)((Object)metadata.getType()));
    }

    private static Class<?> chooseClass(MySqlColumnMetadata metadata, Class<?> type) {
        Class<?> javaType = metadata.getType().getJavaType();
        return type.isAssignableFrom(javaType) ? javaType : type;
    }

    private static Codec<?>[] defaultCodecs(ByteBufAllocator allocator) {
        return new Codec[]{ByteCodec.INSTANCE, ShortCodec.INSTANCE, IntegerCodec.INSTANCE, LongCodec.INSTANCE, BigIntegerCodec.INSTANCE, BigDecimalCodec.INSTANCE, FloatCodec.INSTANCE, DoubleCodec.INSTANCE, BooleanCodec.INSTANCE, BitSetCodec.INSTANCE, ZonedDateTimeCodec.INSTANCE, LocalDateTimeCodec.INSTANCE, InstantCodec.INSTANCE, OffsetDateTimeCodec.INSTANCE, LocalDateCodec.INSTANCE, LocalTimeCodec.INSTANCE, DurationCodec.INSTANCE, OffsetTimeCodec.INSTANCE, YearCodec.INSTANCE, StringCodec.INSTANCE, EnumCodec.INSTANCE, SetCodec.INSTANCE, ClobCodec.INSTANCE, BlobCodec.INSTANCE, ByteBufferCodec.INSTANCE, ByteArrayCodec.INSTANCE};
    }

    static final class Builder
    implements CodecsBuilder {
        private final ByteBufAllocator allocator;
        @GuardedBy(value="lock")
        private final ArrayList<Codec<?>> codecs = new ArrayList();
        private final ReentrantLock lock = new ReentrantLock();

        Builder(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public CodecsBuilder addFirst(Codec<?> codec) {
            this.lock.lock();
            try {
                if (this.codecs.isEmpty()) {
                    Codec[] defaultCodecs = DefaultCodecs.defaultCodecs(this.allocator);
                    this.codecs.ensureCapacity(defaultCodecs.length + 1);
                    this.codecs.add(codec);
                    this.codecs.addAll(InternalArrays.asImmutableList(defaultCodecs));
                } else {
                    this.codecs.add(0, codec);
                }
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        @Override
        public CodecsBuilder addLast(Codec<?> codec) {
            this.lock.lock();
            try {
                if (this.codecs.isEmpty()) {
                    this.codecs.addAll(InternalArrays.asImmutableList(DefaultCodecs.defaultCodecs(this.allocator)));
                }
                this.codecs.add(codec);
            }
            finally {
                this.lock.unlock();
            }
            return this;
        }

        @Override
        public Codecs build() {
            this.lock.lock();
            try {
                block8: {
                    try {
                        if (!this.codecs.isEmpty()) break block8;
                        DefaultCodecs defaultCodecs = new DefaultCodecs(DefaultCodecs.defaultCodecs(this.allocator));
                        this.codecs.clear();
                        this.codecs.trimToSize();
                        return defaultCodecs;
                    }
                    catch (Throwable throwable) {
                        this.codecs.clear();
                        this.codecs.trimToSize();
                        throw throwable;
                    }
                }
                DefaultCodecs defaultCodecs = new DefaultCodecs(this.codecs.toArray(new Codec[0]));
                this.codecs.clear();
                this.codecs.trimToSize();
                return defaultCodecs;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

