/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.client;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.NettyBufferUtils;
import io.asyncer.r2dbc.mysql.message.client.SubsequenceClientMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

public final class LocalInfileResponse
implements SubsequenceClientMessage {
    private final int envelopeId;
    private final String path;
    private final SynchronousSink<?> errorSink;

    public LocalInfileResponse(int envelopeId, String path, SynchronousSink<?> errorSink) {
        AssertUtils.requireNonNull(path, "path must not be null");
        this.envelopeId = envelopeId;
        this.path = path;
        this.errorSink = errorSink;
    }

    public Flux<ByteBuf> encode(ByteBufAllocator allocator, ConnectionContext context) {
        return Flux.defer(() -> {
            int bufferSize = context.getLocalInfileBufferSize();
            AtomicReference error = new AtomicReference();
            return Mono.create(sink -> {
                try {
                    Path safePath = context.getLocalInfilePath();
                    Path file = Paths.get(this.path, new String[0]);
                    if (safePath == null) {
                        String message = "Allowed local file path not set, but attempted to load '" + file + '\'';
                        sink.error((Throwable)new R2dbcPermissionDeniedException(message));
                    } else if (file.startsWith(safePath)) {
                        sink.success((Object)file);
                    } else {
                        String message = String.format("The file '%s' is not under the safe path '%s'", file, safePath);
                        sink.error((Throwable)new R2dbcPermissionDeniedException(message));
                    }
                }
                catch (InvalidPathException e) {
                    sink.error((Throwable)new R2dbcNonTransientResourceException("Invalid path: " + this.path, (Throwable)e));
                }
                catch (Throwable e) {
                    sink.error(e);
                }
            }).flatMapMany(p -> NettyBufferUtils.readFile(p, allocator, bufferSize)).onErrorComplete(e -> {
                error.set(e);
                return true;
            }).concatWith((Publisher)Flux.just((Object)allocator.buffer(0, 0))).doAfterTerminate(() -> {
                Throwable e = error.getAndSet(null);
                if (e != null) {
                    this.errorSink.error(e);
                }
            });
        });
    }

    @Override
    public int getEnvelopeId() {
        return this.envelopeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalInfileResponse)) {
            return false;
        }
        LocalInfileResponse that = (LocalInfileResponse)o;
        return this.envelopeId == that.envelopeId && this.path.equals(that.path);
    }

    public int hashCode() {
        return 31 * this.envelopeId + this.path.hashCode();
    }

    public String toString() {
        return "LocalInfileResponse{envelopeId=" + this.envelopeId + ", path='" + this.path + "'}";
    }
}

