/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.ServerVersion;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.constant.ZeroDateOption;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import java.nio.file.Path;
import java.time.ZoneId;
import org.jetbrains.annotations.Nullable;

public final class ConnectionContext
implements CodecContext {
    private static final ServerVersion NONE_VERSION = ServerVersion.create(0, 0, 0);
    private volatile int connectionId = -1;
    private volatile ServerVersion serverVersion = NONE_VERSION;
    private final ZeroDateOption zeroDateOption;
    @Nullable
    private final Path localInfilePath;
    private final int localInfileBufferSize;
    private final boolean preserveInstants;
    @Nullable
    private ZoneId timeZone;
    private volatile short serverStatuses = (short)2;
    @Nullable
    private volatile Capability capability = null;

    ConnectionContext(ZeroDateOption zeroDateOption, @Nullable Path localInfilePath, int localInfileBufferSize, boolean preserveInstants, @Nullable ZoneId timeZone) {
        this.zeroDateOption = AssertUtils.requireNonNull(zeroDateOption, "zeroDateOption must not be null");
        this.localInfilePath = localInfilePath;
        this.localInfileBufferSize = localInfileBufferSize;
        this.preserveInstants = preserveInstants;
        this.timeZone = timeZone;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public void init(int connectionId, ServerVersion version, Capability capability) {
        this.connectionId = connectionId;
        this.serverVersion = version;
        this.capability = capability;
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public CharCollation getClientCollation() {
        return CharCollation.clientCharCollation();
    }

    @Override
    public boolean isPreserveInstants() {
        return this.preserveInstants;
    }

    @Override
    public ZoneId getTimeZone() {
        if (this.timeZone == null) {
            throw new IllegalStateException("Server timezone have not initialization");
        }
        return this.timeZone;
    }

    public boolean isTimeZoneInitialized() {
        return this.timeZone != null;
    }

    @Override
    public boolean isMariaDb() {
        Capability capability = this.capability;
        return capability != null && capability.isMariaDb() || this.serverVersion.isMariaDb();
    }

    void setTimeZone(ZoneId timeZone) {
        if (this.isTimeZoneInitialized()) {
            throw new IllegalStateException("Server timezone have been initialized");
        }
        this.timeZone = timeZone;
    }

    @Override
    public ZeroDateOption getZeroDateOption() {
        return this.zeroDateOption;
    }

    @Nullable
    public Path getLocalInfilePath() {
        return this.localInfilePath;
    }

    public int getLocalInfileBufferSize() {
        return this.localInfileBufferSize;
    }

    public short getServerStatuses() {
        return this.serverStatuses;
    }

    public void setServerStatuses(short serverStatuses) {
        this.serverStatuses = serverStatuses;
    }

    public Capability getCapability() {
        return this.capability;
    }
}

