/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.Extensions;
import io.asyncer.r2dbc.mysql.MySqlConnection;
import io.asyncer.r2dbc.mysql.MySqlConnectionConfiguration;
import io.asyncer.r2dbc.mysql.MySqlConnectionFactoryMetadata;
import io.asyncer.r2dbc.mysql.MySqlSslConfiguration;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.cache.Caches;
import io.asyncer.r2dbc.mysql.cache.PrepareCache;
import io.asyncer.r2dbc.mysql.cache.QueryCache;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.codec.CodecsBuilder;
import io.asyncer.r2dbc.mysql.constant.CompressionAlgorithm;
import io.asyncer.r2dbc.mysql.constant.SslMode;
import io.asyncer.r2dbc.mysql.extension.CodecRegistrar;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.unix.DomainSocketAddress;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class MySqlConnectionFactory
implements ConnectionFactory {
    private final Mono<MySqlConnection> client;

    private MySqlConnectionFactory(Mono<MySqlConnection> client) {
        this.client = client;
    }

    public Mono<MySqlConnection> create() {
        return this.client;
    }

    public ConnectionFactoryMetadata getMetadata() {
        return MySqlConnectionFactoryMetadata.INSTANCE;
    }

    public static MySqlConnectionFactory from(MySqlConnectionConfiguration configuration) {
        AssertUtils.requireNonNull(configuration, "configuration must not be null");
        LazyQueryCache queryCache = new LazyQueryCache(configuration.getQueryCacheSize());
        return new MySqlConnectionFactory((Mono<MySqlConnection>)Mono.defer(() -> {
            List<String> sessionVariables;
            Object address;
            MySqlSslConfiguration ssl;
            if (configuration.isHost()) {
                ssl = configuration.getSsl();
                address = InetSocketAddress.createUnresolved(configuration.getDomain(), configuration.getPort());
            } else {
                ssl = MySqlSslConfiguration.disabled();
                address = new DomainSocketAddress(configuration.getDomain());
            }
            String database = configuration.getDatabase();
            boolean createDbIfNotExist = configuration.isCreateDatabaseIfNotExist();
            String user = configuration.getUser();
            CharSequence password = configuration.getPassword();
            SslMode sslMode = ssl.getSslMode();
            int zstdCompressionLevel = configuration.getZstdCompressionLevel();
            ZoneId connectionTimeZone = MySqlConnectionFactory.retrieveZoneId(configuration.getConnectionTimeZone());
            ConnectionContext context = new ConnectionContext(configuration.getZeroDateOption(), configuration.getLoadLocalInfilePath(), configuration.getLocalInfileBufferSize(), configuration.isPreserveInstants(), connectionTimeZone);
            Set<CompressionAlgorithm> compressionAlgorithms = configuration.getCompressionAlgorithms();
            Extensions extensions = configuration.getExtensions();
            Predicate<String> prepare = configuration.getPreferPrepareStatement();
            int prepareCacheSize = configuration.getPrepareCacheSize();
            Publisher<String> passwordPublisher = configuration.getPasswordPublisher();
            boolean forceTimeZone = configuration.isForceConnectionTimeZoneToSession();
            List<String> list = sessionVariables = forceTimeZone && connectionTimeZone != null ? MySqlConnectionFactory.mergeSessionVariables(configuration.getSessionVariables(), connectionTimeZone) : configuration.getSessionVariables();
            if (Objects.nonNull(passwordPublisher)) {
                return Mono.from(passwordPublisher).flatMap(arg_0 -> MySqlConnectionFactory.lambda$null$0(configuration, queryCache, ssl, (SocketAddress)address, database, createDbIfNotExist, user, sslMode, compressionAlgorithms, zstdCompressionLevel, context, extensions, sessionVariables, prepare, prepareCacheSize, arg_0));
            }
            return MySqlConnectionFactory.getMySqlConnection(configuration, queryCache, ssl, (SocketAddress)address, database, createDbIfNotExist, user, sslMode, compressionAlgorithms, zstdCompressionLevel, context, extensions, sessionVariables, prepare, prepareCacheSize, password);
        }));
    }

    private static Mono<MySqlConnection> getMySqlConnection(MySqlConnectionConfiguration configuration, LazyQueryCache queryCache, MySqlSslConfiguration ssl, SocketAddress address, String database, boolean createDbIfNotExist, String user, SslMode sslMode, Set<CompressionAlgorithm> compressionAlgorithms, int zstdCompressionLevel, ConnectionContext context, Extensions extensions, List<String> sessionVariables, @Nullable Predicate<String> prepare, int prepareCacheSize, @Nullable CharSequence password) {
        return Client.connect(ssl, address, configuration.isTcpKeepAlive(), configuration.isTcpNoDelay(), context, configuration.getConnectTimeout(), configuration.getLoopResources()).flatMap(client -> {
            String db = createDbIfNotExist ? "" : database;
            return QueryFlow.login(client, sslMode, db, user, password, compressionAlgorithms, zstdCompressionLevel, context);
        }).flatMap(client -> {
            ByteBufAllocator allocator = client.getByteBufAllocator();
            CodecsBuilder builder = Codecs.builder();
            PrepareCache prepareCache = Caches.createPrepareCache(prepareCacheSize);
            String db = createDbIfNotExist ? database : "";
            extensions.forEach(CodecRegistrar.class, registrar -> registrar.register(allocator, builder));
            return MySqlConnection.init(client, builder.build(), context, db, queryCache.get(), prepareCache, sessionVariables, prepare);
        });
    }

    @Nullable
    private static ZoneId retrieveZoneId(String timeZone) {
        if ("LOCAL".equalsIgnoreCase(timeZone)) {
            return ZoneId.systemDefault().normalized();
        }
        if ("SERVER".equalsIgnoreCase(timeZone)) {
            return null;
        }
        return StringUtils.parseZoneId(timeZone);
    }

    private static List<String> mergeSessionVariables(List<String> sessionVariables, ZoneId timeZone) {
        ArrayList<String> res = new ArrayList<String>(sessionVariables.size() + 1);
        String offerStr = timeZone instanceof ZoneOffset && "Z".equalsIgnoreCase(timeZone.getId()) ? "+00:00" : timeZone.getId();
        res.addAll(sessionVariables);
        res.add("time_zone='" + offerStr + "'");
        return res;
    }

    private static /* synthetic */ Mono lambda$null$0(MySqlConnectionConfiguration configuration, LazyQueryCache queryCache, MySqlSslConfiguration ssl, SocketAddress address, String database, boolean createDbIfNotExist, String user, SslMode sslMode, Set compressionAlgorithms, int zstdCompressionLevel, ConnectionContext context, Extensions extensions, List sessionVariables, Predicate prepare, int prepareCacheSize, String token) {
        return MySqlConnectionFactory.getMySqlConnection(configuration, queryCache, ssl, address, database, createDbIfNotExist, user, sslMode, compressionAlgorithms, zstdCompressionLevel, context, extensions, sessionVariables, prepare, prepareCacheSize, token);
    }

    private static final class LazyQueryCache {
        private final int capacity;
        private final ReentrantLock lock = new ReentrantLock();
        @Nullable
        private volatile QueryCache cache;

        private LazyQueryCache(int capacity) {
            this.capacity = capacity;
        }

        public QueryCache get() {
            QueryCache cache = this.cache;
            if (cache == null) {
                this.lock.lock();
                try {
                    cache = this.cache;
                    if (cache == null) {
                        this.cache = cache = Caches.createQueryCache(this.capacity);
                    }
                    QueryCache queryCache = cache;
                    return queryCache;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return cache;
        }
    }
}

