/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Binding;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlResult;
import io.asyncer.r2dbc.mysql.MySqlStatement;
import io.asyncer.r2dbc.mysql.ParametrizedStatementSupport;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.cache.PrepareCache;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.List;
import reactor.core.publisher.Flux;

final class PrepareParametrizedStatement
extends ParametrizedStatementSupport {
    private final PrepareCache prepareCache;
    private int fetchSize = 0;

    PrepareParametrizedStatement(Client client, Codecs codecs, Query query, ConnectionContext context, PrepareCache prepareCache) {
        super(client, codecs, query, context);
        this.prepareCache = prepareCache;
    }

    @Override
    public Flux<MySqlResult> execute(List<Binding> bindings) {
        return Flux.defer(() -> QueryFlow.execute(this.client, StringUtils.extendReturning(this.query.getFormattedSql(), this.returningIdentifiers()), bindings, this.fetchSize, this.prepareCache)).map(messages -> MySqlResult.toResult(true, this.codecs, this.context, this.syntheticKeyName(), (Flux<ServerMessage>)messages));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }
}

