/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class BooleanCodec
extends AbstractPrimitiveCodec<Boolean> {
    static final BooleanCodec INSTANCE = new BooleanCodec();

    private BooleanCodec() {
        super(Boolean.TYPE, Boolean.class);
    }

    @Override
    public Boolean decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return binary || metadata.getType() == MySqlType.BIT ? value.readBoolean() : value.readByte() != 48;
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return (Boolean)value != false ? BooleanMySqlParameter.TRUE : BooleanMySqlParameter.FALSE;
    }

    @Override
    public boolean canPrimitiveDecode(MySqlColumnMetadata metadata) {
        MySqlType type = metadata.getType();
        return (type == MySqlType.BIT || type == MySqlType.TINYINT) && metadata.getNativePrecision() == 1L;
    }

    private static final class BooleanMySqlParameter
    extends AbstractMySqlParameter {
        private static final BooleanMySqlParameter TRUE = new BooleanMySqlParameter(true);
        private static final BooleanMySqlParameter FALSE = new BooleanMySqlParameter(false);
        private final boolean value;

        private BooleanMySqlParameter(boolean value) {
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> allocator.buffer(1).writeByte(this.value ? 1 : 0));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value ? 1 : 0));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TINYINT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanMySqlParameter)) {
                return false;
            }
            BooleanMySqlParameter that = (BooleanMySqlParameter)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }

        @Override
        public String toString() {
            return Boolean.toString(this.value);
        }
    }
}

