/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.IntegerCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import reactor.core.publisher.Mono;

final class ByteCodec
extends AbstractPrimitiveCodec<Byte> {
    static final ByteCodec INSTANCE = new ByteCodec();

    private ByteCodec() {
        super(Byte.TYPE, Byte.class);
    }

    @Override
    public Byte decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return (byte)IntegerCodec.decodeInt(value, binary, metadata.getType());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Byte;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new ByteMySqlParameter((Byte)value);
    }

    @Override
    public boolean canPrimitiveDecode(MySqlColumnMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    static final class ByteMySqlParameter
    extends AbstractMySqlParameter {
        private final byte value;

        ByteMySqlParameter(byte value) {
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> allocator.buffer(1).writeByte((int)this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TINYINT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteMySqlParameter)) {
                return false;
            }
            ByteMySqlParameter byteValue = (ByteMySqlParameter)o;
            return this.value == byteValue.value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public String toString() {
            return Byte.toString(this.value);
        }
    }
}

