/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.Codec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.DateTimes;
import io.asyncer.r2dbc.mysql.codec.LocalDateTimeCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.core.publisher.Mono;

final class InstantCodec
implements Codec<Instant> {
    static final InstantCodec INSTANCE = new InstantCodec();

    private InstantCodec() {
    }

    @Override
    public Instant decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        LocalDateTime origin = LocalDateTimeCodec.decodeOrigin(value, binary, context);
        if (origin == null) {
            return null;
        }
        ZoneId zone = context.isPreserveInstants() ? context.getTimeZone() : ZoneOffset.systemDefault();
        return origin.toInstant(zone instanceof ZoneOffset ? (ZoneOffset)zone : zone.getRules().getOffset(origin));
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new InstantMySqlParameter((Instant)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Instant;
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        return DateTimes.canDecodeDateTime(metadata.getType(), target, Instant.class);
    }

    private static final class InstantMySqlParameter
    extends AbstractMySqlParameter {
        private final Instant value;
        private final CodecContext context;

        private InstantMySqlParameter(Instant value, CodecContext context) {
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> LocalDateTimeCodec.encodeBinary(allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateTimeCodec.encodeText(writer, this.serverValue()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TIMESTAMP;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstantMySqlParameter that = (InstantMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalDateTime serverValue() {
            return LocalDateTime.ofInstant(this.value, this.context.isPreserveInstants() ? this.context.getTimeZone() : ZoneId.systemDefault());
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

