/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlColumnMetadata;
import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.DateTimes;
import io.asyncer.r2dbc.mysql.codec.LocalDateTimeCodec;
import io.asyncer.r2dbc.mysql.codec.ParametrizedCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

final class ZonedDateTimeCodec
implements ParametrizedCodec<ZonedDateTime> {
    static final ZonedDateTimeCodec INSTANCE = new ZonedDateTimeCodec();

    private ZonedDateTimeCodec() {
    }

    @Override
    public ZonedDateTime decode(ByteBuf value, MySqlColumnMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return ZonedDateTimeCodec.decode0(value, binary, context);
    }

    @Override
    public ChronoZonedDateTime<LocalDate> decode(ByteBuf value, MySqlColumnMetadata metadata, ParameterizedType target, boolean binary, CodecContext context) {
        return ZonedDateTimeCodec.decode0(value, binary, context);
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new ZonedDateTimeMySqlParameter((ZonedDateTime)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof ZonedDateTime;
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, ParameterizedType target) {
        return DateTimes.canDecodeChronology(metadata.getType(), target, ChronoZonedDateTime.class);
    }

    @Override
    public boolean canDecode(MySqlColumnMetadata metadata, Class<?> target) {
        return DateTimes.canDecodeDateTime(metadata.getType(), target, ZonedDateTime.class);
    }

    @Nullable
    private static ZonedDateTime decode0(ByteBuf value, boolean binary, CodecContext context) {
        LocalDateTime origin = LocalDateTimeCodec.decodeOrigin(value, binary, context);
        if (origin == null) {
            return null;
        }
        return ZonedDateTime.of(origin, context.isPreserveInstants() ? context.getTimeZone() : ZoneId.systemDefault());
    }

    private static final class ZonedDateTimeMySqlParameter
    extends AbstractMySqlParameter {
        private final ZonedDateTime value;
        private final CodecContext context;

        private ZonedDateTimeMySqlParameter(ZonedDateTime value, CodecContext context) {
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> LocalDateTimeCodec.encodeBinary(allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateTimeCodec.encodeText(writer, this.serverValue()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TIMESTAMP;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ZonedDateTimeMySqlParameter)) {
                return false;
            }
            ZonedDateTimeMySqlParameter that = (ZonedDateTimeMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalDateTime serverValue() {
            ZoneId zoneId = this.context.isPreserveInstants() ? this.context.getTimeZone() : ZoneId.systemDefault().normalized();
            return this.value.withZoneSameInstant(zoneId).toLocalDateTime();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

