/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.InsertSyntheticRow;
import io.asyncer.r2dbc.mysql.MySqlDataRow;
import io.asyncer.r2dbc.mysql.MySqlRowDescriptor;
import io.asyncer.r2dbc.mysql.MySqlStatementSupport;
import io.asyncer.r2dbc.mysql.api.MySqlResult;
import io.asyncer.r2dbc.mysql.api.MySqlRow;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.NettyBufferUtils;
import io.asyncer.r2dbc.mysql.internal.util.OperatorUtils;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import io.asyncer.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.OkMessage;
import io.asyncer.r2dbc.mysql.message.server.RowMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.asyncer.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

final class MySqlSegmentResult
implements MySqlResult {
    private final Flux<MySqlResult.Segment> segments;

    private MySqlSegmentResult(Flux<MySqlResult.Segment> segments) {
        this.segments = segments;
    }

    @Override
    public Mono<Long> getRowsUpdated() {
        return this.segments.handle((segment, sink) -> {
            if (segment instanceof MySqlResult.UpdateCount) {
                sink.next((Object)((MySqlResult.UpdateCount)segment).value());
            } else if (segment instanceof MySqlResult.Message) {
                sink.error((Throwable)((MySqlResult.Message)segment).exception());
            } else if (segment instanceof ReferenceCounted) {
                ReferenceCountUtil.safeRelease((Object)segment);
            }
        }).reduce(Long::sum);
    }

    @Override
    public <T> Flux<T> map(BiFunction<Row, RowMetadata, ? extends T> f) {
        AssertUtils.requireNonNull(f, "mapping function must not be null");
        return this.segments.handle((segment, sink) -> {
            if (segment instanceof MySqlResult.RowSegment) {
                MySqlRow row = ((MySqlResult.RowSegment)segment).row();
                try {
                    sink.next(f.apply(row, row.getMetadata()));
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)segment);
                }
            } else if (segment instanceof MySqlResult.Message) {
                sink.error((Throwable)((MySqlResult.Message)segment).exception());
            } else if (segment instanceof ReferenceCounted) {
                ReferenceCountUtil.safeRelease((Object)segment);
            }
        });
    }

    @Override
    public <T> Flux<T> map(Function<? super Readable, ? extends T> f) {
        AssertUtils.requireNonNull(f, "mapping function must not be null");
        return this.segments.handle((segment, sink) -> {
            if (segment instanceof MySqlResult.RowSegment) {
                try {
                    sink.next(f.apply(((MySqlResult.RowSegment)segment).row()));
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)segment);
                }
            } else if (segment instanceof MySqlResult.Message) {
                sink.error((Throwable)((MySqlResult.Message)segment).exception());
            } else if (segment instanceof ReferenceCounted) {
                ReferenceCountUtil.safeRelease((Object)segment);
            }
        });
    }

    @Override
    public MySqlResult filter(Predicate<Result.Segment> filter) {
        AssertUtils.requireNonNull(filter, "filter must not be null");
        return new MySqlSegmentResult((Flux<MySqlResult.Segment>)this.segments.filter(segment -> {
            if (filter.test((Result.Segment)segment)) {
                return true;
            }
            if (segment instanceof ReferenceCounted) {
                ReferenceCountUtil.safeRelease((Object)segment);
            }
            return false;
        }));
    }

    @Override
    public <T> Flux<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> f) {
        AssertUtils.requireNonNull(f, "mapping function must not be null");
        return this.segments.flatMap(segment -> {
            Publisher ret = (Publisher)f.apply((Result.Segment)segment);
            if (ret == null) {
                return Mono.error((Throwable)new IllegalStateException("The mapper returned a null Publisher"));
            }
            if (ret instanceof Mono) {
                Mono mono = (Mono)ret;
                return mono.doAfterTerminate(() -> ReferenceCountUtil.release((Object)segment));
            }
            return Flux.from((Publisher)ret).doAfterTerminate(() -> ReferenceCountUtil.release((Object)segment));
        });
    }

    static MySqlResult toResult(boolean binary, Client client, Codecs codecs, @Nullable String syntheticKeyName, Flux<ServerMessage> messages) {
        AssertUtils.requireNonNull(client, "client must not be null");
        AssertUtils.requireNonNull(codecs, "codecs must not be null");
        AssertUtils.requireNonNull(messages, "messages must not be null");
        return new MySqlSegmentResult((Flux<MySqlResult.Segment>)OperatorUtils.discardOnCancel(messages).doOnDiscard(ReferenceCounted.class, ReferenceCounted::release).handle((BiConsumer)new MySqlSegments(binary, client, codecs, syntheticKeyName)));
    }

    private static final class MySqlSegments
    implements BiConsumer<ServerMessage, SynchronousSink<MySqlResult.Segment>> {
        private final boolean binary;
        private final Client client;
        private final Codecs codecs;
        @Nullable
        private final String syntheticKeyName;
        private final AtomicLong rowCount = new AtomicLong(0L);
        private MySqlRowDescriptor rowMetadata;

        private MySqlSegments(boolean binary, Client client, Codecs codecs, @Nullable String syntheticKeyName) {
            this.binary = binary;
            this.client = client;
            this.codecs = codecs;
            this.syntheticKeyName = syntheticKeyName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(ServerMessage message, SynchronousSink<MySqlResult.Segment> sink) {
            if (message instanceof RowMessage) {
                FieldValue[] fields;
                this.rowCount.getAndIncrement();
                MySqlRowDescriptor metadata = this.rowMetadata;
                if (metadata == null) {
                    ReferenceCountUtil.safeRelease((Object)message);
                    sink.error((Throwable)new IllegalStateException("No metadata available"));
                    return;
                }
                try {
                    fields = ((RowMessage)message).decode(this.binary, metadata.unwrap());
                }
                finally {
                    ReferenceCountUtil.safeRelease((Object)message);
                }
                sink.next((Object)new MySqlRowSegment(fields, metadata, this.codecs, this.binary, this.client.getContext()));
            } else if (message instanceof SyntheticMetadataMessage) {
                DefinitionMetadataMessage[] metadataMessages = ((SyntheticMetadataMessage)message).unwrap();
                if (metadataMessages.length == 0) {
                    return;
                }
                this.rowMetadata = MySqlRowDescriptor.create(metadataMessages);
            } else if (message instanceof OkMessage) {
                OkMessage msg = (OkMessage)message;
                if (MySqlStatementSupport.supportReturning(this.client.getContext()) && msg.isEndOfRows()) {
                    sink.next((Object)new MySqlUpdateCount(this.rowCount.getAndSet(0L)));
                } else {
                    long rows = msg.getAffectedRows();
                    MySqlUpdateCount segment = this.syntheticKeyName == null ? new MySqlUpdateCount(rows) : new MySqlOkSegment(rows, msg.getLastInsertId(), this.codecs, this.syntheticKeyName);
                    sink.next((Object)segment);
                }
            } else if (message instanceof ErrorMessage) {
                sink.next((Object)new MySqlMessage((ErrorMessage)message));
            } else {
                ReferenceCountUtil.safeRelease((Object)message);
            }
        }
    }

    private static final class MySqlOkSegment
    extends MySqlUpdateCount
    implements MySqlResult.RowSegment {
        private final long lastInsertId;
        private final Codecs codecs;
        private final String keyName;

        private MySqlOkSegment(long rows, long lastInsertId, Codecs codecs, String keyName) {
            super(rows);
            this.lastInsertId = lastInsertId;
            this.codecs = codecs;
            this.keyName = keyName;
        }

        @Override
        public MySqlRow row() {
            return new InsertSyntheticRow(this.codecs, this.keyName, this.lastInsertId);
        }
    }

    private static class MySqlUpdateCount
    implements MySqlResult.UpdateCount {
        private final long rows;

        private MySqlUpdateCount(long rows) {
            this.rows = rows;
        }

        public long value() {
            return this.rows;
        }
    }

    private static final class MySqlRowSegment
    extends AbstractReferenceCounted
    implements MySqlResult.RowSegment {
        private final MySqlRow row;
        private final FieldValue[] fields;

        private MySqlRowSegment(FieldValue[] fields, MySqlRowDescriptor metadata, Codecs codecs, boolean binary, ConnectionContext context) {
            this.row = new MySqlDataRow(fields, metadata, codecs, binary, context);
            this.fields = fields;
        }

        @Override
        public MySqlRow row() {
            return this.row;
        }

        public ReferenceCounted touch(Object hint) {
            for (FieldValue field : this.fields) {
                field.touch(hint);
            }
            return this;
        }

        protected void deallocate() {
            NettyBufferUtils.releaseAll(this.fields);
        }
    }

    private static final class MySqlMessage
    implements MySqlResult.Message {
        private final ErrorMessage message;

        private MySqlMessage(ErrorMessage message) {
            this.message = message;
        }

        public R2dbcException exception() {
            return this.message.toException();
        }

        public int errorCode() {
            return this.message.getCode();
        }

        public String sqlState() {
            return this.message.getSqlState();
        }

        public String message() {
            return this.message.getMessage();
        }
    }
}

