/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.Codec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.DateTimes;
import io.asyncer.r2dbc.mysql.codec.LocalDateTimeCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import reactor.core.publisher.Mono;

final class OffsetDateTimeCodec
implements Codec<OffsetDateTime> {
    static final OffsetDateTimeCodec INSTANCE = new OffsetDateTimeCodec();

    private OffsetDateTimeCodec() {
    }

    @Override
    public Class<? extends OffsetDateTime> getMainClass() {
        return OffsetDateTime.class;
    }

    @Override
    public OffsetDateTime decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        LocalDateTime origin = LocalDateTimeCodec.decodeOrigin(value, binary, context);
        if (origin == null) {
            return null;
        }
        ZoneId zone = context.isPreserveInstants() ? context.getTimeZone() : ZoneId.systemDefault();
        return OffsetDateTime.of(origin, zone instanceof ZoneOffset ? (ZoneOffset)zone : zone.getRules().getOffset(origin));
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new OffsetDateTimeMySqlParameter((OffsetDateTime)value, context);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof OffsetDateTime;
    }

    @Override
    public boolean canDecode(MySqlReadableMetadata metadata, Class<?> target) {
        return DateTimes.canDecodeDateTime(metadata.getType(), target, OffsetDateTime.class);
    }

    private static final class OffsetDateTimeMySqlParameter
    extends AbstractMySqlParameter {
        private final OffsetDateTime value;
        private final CodecContext context;

        private OffsetDateTimeMySqlParameter(OffsetDateTime value, CodecContext context) {
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> LocalDateTimeCodec.encodeBinary(allocator, this.serverValue()));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> LocalDateTimeCodec.encodeText(writer, this.serverValue()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.TIMESTAMP;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OffsetDateTimeMySqlParameter that = (OffsetDateTimeMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        private LocalDateTime serverValue() {
            ZoneId zone = this.context.isPreserveInstants() ? this.context.getTimeZone() : ZoneId.systemDefault().normalized();
            return zone instanceof ZoneOffset ? this.value.withOffsetSameInstant((ZoneOffset)zone).toLocalDateTime() : this.value.toZonedDateTime().withZoneSameInstant(zone).toLocalDateTime();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

