/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.message.server.HandshakeHeader;
import io.asyncer.r2dbc.mysql.message.server.HandshakeRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Arrays;

final class HandshakeV9Request
implements HandshakeRequest {
    private static final Capability SERVER_CAPABILITY = Capability.of(0L);
    private final HandshakeHeader header;
    private final byte[] salt;

    private HandshakeV9Request(HandshakeHeader header, byte[] salt) {
        this.header = AssertUtils.requireNonNull(header, "header must not be null");
        this.salt = AssertUtils.requireNonNull(salt, "salt must not be null");
    }

    @Override
    public HandshakeHeader getHeader() {
        return this.header;
    }

    @Override
    public Capability getServerCapability() {
        return SERVER_CAPABILITY;
    }

    @Override
    public String getAuthType() {
        return "mysql_old_password";
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HandshakeV9Request)) {
            return false;
        }
        HandshakeV9Request that = (HandshakeV9Request)o;
        return this.header.equals(that.header) && Arrays.equals(this.salt, that.salt);
    }

    public int hashCode() {
        int result = this.header.hashCode();
        return 31 * result + Arrays.hashCode(this.salt);
    }

    public String toString() {
        return "HandshakeV9Request{header=" + this.header + ", salt=REDACTED}";
    }

    static HandshakeV9Request decode(ByteBuf buf, HandshakeHeader header) {
        int bytes = buf.readableBytes();
        if (bytes <= 0) {
            return new HandshakeV9Request(header, InternalArrays.EMPTY_BYTES);
        }
        byte[] salt = buf.getByte(buf.writerIndex() - 1) == 0 ? ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)(bytes - 1)) : ByteBufUtil.getBytes((ByteBuf)buf);
        return new HandshakeV9Request(header, salt);
    }
}

