/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import io.asyncer.r2dbc.mysql.message.NormalFieldValue;
import io.asyncer.r2dbc.mysql.message.server.FieldReader;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;

final class NormalFieldReader
implements FieldReader {
    private final ByteBuf buf;

    NormalFieldReader(ByteBuf buf) {
        this.buf = buf;
    }

    @Override
    public short getUnsignedByte() {
        return this.buf.getUnsignedByte(this.buf.readerIndex());
    }

    @Override
    public void skipOneByte() {
        this.buf.skipBytes(1);
    }

    @Override
    public byte[] readSizeFixedBytes(int length) {
        AssertUtils.require(length > 0, "length must be a positive integer");
        return ByteBufUtil.getBytes((ByteBuf)this.buf.readSlice(length));
    }

    @Override
    public FieldValue readSizeFixedField(int length) {
        AssertUtils.require(length > 0, "length must be a positive integer");
        return new NormalFieldValue(this.buf.readRetainedSlice(length));
    }

    @Override
    public FieldValue readVarIntSizedField() {
        return new NormalFieldValue(NormalFieldReader.readVarIntSizedRetained(this.buf));
    }

    public int refCnt() {
        return this.buf.refCnt();
    }

    public NormalFieldReader retain() {
        this.buf.retain();
        return this;
    }

    public NormalFieldReader retain(int increment) {
        this.buf.retain(increment);
        return this;
    }

    public NormalFieldReader touch() {
        this.buf.touch();
        return this;
    }

    public NormalFieldReader touch(Object hint) {
        this.buf.touch(hint);
        return this;
    }

    public boolean release() {
        return this.buf.release();
    }

    public boolean release(int decrement) {
        return this.buf.release(decrement);
    }

    private static ByteBuf readVarIntSizedRetained(ByteBuf buf) {
        int size = (int)VarIntUtils.readVarInt(buf);
        if (size == 0) {
            return buf.alloc().buffer(0, 0);
        }
        return buf.readRetainedSlice(size);
    }
}

