/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.ServerVersion;
import io.asyncer.r2dbc.mysql.api.MySqlStatement;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import org.jetbrains.annotations.Nullable;

abstract class MySqlStatementSupport
implements MySqlStatement {
    private static final ServerVersion MARIA_10_5_1 = ServerVersion.create(10, 5, 1, true);
    private static final String LAST_INSERT_ID = "LAST_INSERT_ID";
    protected final Client client;
    @Nullable
    private String[] generatedColumns = null;

    MySqlStatementSupport(Client client) {
        this.client = AssertUtils.requireNonNull(client, "client must not be null");
    }

    @Override
    public final MySqlStatement returnGeneratedValues(String ... columns) {
        AssertUtils.requireNonNull(columns, "columns must not be null");
        ConnectionContext context = this.client.getContext();
        int len = columns.length;
        if (len == 0) {
            this.generatedColumns = InternalArrays.EMPTY_STRINGS;
        } else if (len == 1 || MySqlStatementSupport.supportReturning(context)) {
            String[] result = new String[len];
            for (int i = 0; i < len; ++i) {
                AssertUtils.requireNonEmpty(columns[i], "returning column must not be empty");
                result[i] = columns[i];
            }
            this.generatedColumns = result;
        } else {
            String db = context.isMariaDb() ? "MariaDB 10.5.0 or below" : "MySQL";
            throw new IllegalArgumentException(db + " can have only one column");
        }
        return this;
    }

    @Nullable
    final String syntheticKeyName() {
        String[] columns = this.generatedColumns;
        if (columns == null || MySqlStatementSupport.supportReturning(this.client.getContext())) {
            return null;
        }
        if (columns.length == 0) {
            return LAST_INSERT_ID;
        }
        return columns[0];
    }

    final String returningIdentifiers() {
        CharSequence[] columns = this.generatedColumns;
        if (columns == null || !MySqlStatementSupport.supportReturning(this.client.getContext())) {
            return "";
        }
        if (columns.length == 0) {
            return "*";
        }
        return String.join((CharSequence)",", columns);
    }

    static boolean supportReturning(ConnectionContext context) {
        return context.isMariaDb() && context.getServerVersion().isGreaterThanOrEqualTo(MARIA_10_5_1);
    }
}

