/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.client;

import io.asyncer.r2dbc.mysql.client.Compressor;
import io.asyncer.r2dbc.mysql.client.PacketEvent;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

final class CompressionDuplexCodec
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    static final String NAME = "R2dbcMysqlCompressionDuplexCodec";
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CompressionDuplexCodec.class);
    private static final int MIN_COMPRESS_LENGTH = 50;
    private final AtomicInteger sequenceId = new AtomicInteger(0);
    private final Compressor compressor;
    @Nullable
    private ByteBuf writeCumulated;
    private final ByteToMessageDecoder.Cumulator writeCumulator = MERGE_CUMULATOR;
    private int frameLength = -1;

    CompressionDuplexCodec(Compressor compressor) {
        this.compressor = compressor;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ByteBuf cumulated = this.writeCumulated == null ? ctx.alloc().buffer(0, 0) : this.writeCumulated;
            this.writeCumulated = cumulated = this.writeCumulator.cumulate(ctx.alloc(), cumulated, (ByteBuf)msg);
            while (cumulated.readableBytes() >= 0xFFFFFF) {
                logger.trace("Accumulated to the maximum payload, compressing");
                ByteBuf slice = cumulated.readSlice(0xFFFFFF);
                ByteBuf compressed = this.compressor.compress(slice);
                if (compressed.readableBytes() >= slice.readableBytes()) {
                    logger.trace("Sending uncompressed due to compressed payload is larger than original");
                    compressed.release();
                    ctx.write((Object)this.buildHeader(ctx, slice.readableBytes(), 0));
                    ctx.write((Object)slice.retain());
                    continue;
                }
                logger.trace("Sending compressed payload");
                ctx.write((Object)this.buildHeader(ctx, compressed.readableBytes(), 0xFFFFFF));
                ctx.write((Object)compressed);
            }
            if (!cumulated.isReadable()) {
                this.writeCumulated = null;
                cumulated.release();
            } else {
                logger.trace("Accumulated writing buffers, waiting for flush");
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    private ByteBuf buildHeader(ChannelHandlerContext ctx, int compressedSize, int uncompressedSize) {
        return ctx.alloc().ioBuffer(7).writeMediumLE(compressedSize).writeByte(this.sequenceId.getAndIncrement()).writeMediumLE(uncompressedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(ChannelHandlerContext ctx) {
        ByteBuf cumulated = this.writeCumulated;
        this.writeCumulated = null;
        if (cumulated == null) {
            ctx.flush();
            return;
        }
        int uncompressedSize = cumulated.readableBytes();
        if (uncompressedSize < 50) {
            logger.trace("flushing, payload is too small to compress, sending uncompressed");
            ctx.write((Object)this.buildHeader(ctx, uncompressedSize, 0));
            ctx.writeAndFlush((Object)cumulated);
        } else {
            try {
                logger.trace("flushing, compressing payload");
                ByteBuf compressed = this.compressor.compress(cumulated);
                if (compressed.readableBytes() >= uncompressedSize) {
                    logger.trace("Sending uncompressed due to compressed payload is larger than original");
                    compressed.release();
                    ctx.write((Object)this.buildHeader(ctx, uncompressedSize, 0));
                    ctx.writeAndFlush((Object)cumulated.retain());
                } else {
                    logger.trace("Sending compressed payload");
                    ctx.write((Object)this.buildHeader(ctx, compressed.readableBytes(), uncompressedSize));
                    ctx.writeAndFlush((Object)compressed);
                }
            }
            finally {
                cumulated.release();
            }
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ByteBuf frame = this.decode(in);
        if (frame != null) {
            out.add(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ByteBuf decode(ByteBuf in) {
        if (this.frameLength == -1) {
            if (in.readableBytes() < 3) {
                return null;
            }
            this.frameLength = in.getUnsignedMediumLE(in.readerIndex()) + 7;
        }
        if (in.readableBytes() < this.frameLength) {
            return null;
        }
        in.skipBytes(3);
        short sequenceId = in.readUnsignedByte();
        int uncompressedSize = in.readUnsignedMediumLE();
        ByteBuf frame = in.readRetainedSlice(this.frameLength - 7);
        logger.trace("Decoded frame with sequence id: {}, total size: {}, uncompressed size: {}", new Object[]{(int)sequenceId, this.frameLength, uncompressedSize});
        this.frameLength = -1;
        this.sequenceId.set(sequenceId + 1);
        if (uncompressedSize == 0) {
            return frame;
        }
        try {
            ByteBuf byteBuf = this.compressor.decompress(frame, uncompressedSize);
            return byteBuf;
        }
        finally {
            frame.release();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (PacketEvent.RESET_SEQUENCE == evt) {
            logger.debug("Reset sequence id");
            this.sequenceId.set(0);
        }
        ctx.fireUserEventTriggered(evt);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) {
        ctx.read();
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.compressor.dispose();
    }
}

