/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Binding;
import io.asyncer.r2dbc.mysql.MySqlSegmentResult;
import io.asyncer.r2dbc.mysql.ParameterizedStatementSupport;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.api.MySqlResult;
import io.asyncer.r2dbc.mysql.api.MySqlStatement;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import java.util.List;
import reactor.core.publisher.Flux;

final class PrepareParameterizedStatement
extends ParameterizedStatementSupport {
    private int fetchSize = 0;

    PrepareParameterizedStatement(Client client, Codecs codecs, Query query) {
        super(client, codecs, query);
    }

    public Flux<MySqlResult> execute(List<Binding> bindings) {
        return Flux.defer(() -> QueryFlow.execute(this.client, StringUtils.extendReturning(this.query.getFormattedSql(), this.returningIdentifiers()), bindings, this.fetchSize)).map(messages -> MySqlSegmentResult.toResult(true, this.client, this.codecs, this.syntheticKeyName(), (Flux<ServerMessage>)messages));
    }

    @Override
    public MySqlStatement fetchSize(int rows) {
        AssertUtils.require(rows >= 0, "Fetch size must be greater or equal to zero");
        this.fetchSize = rows;
        return this;
    }
}

