/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.ByteCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.codec.IntegerCodec;
import io.asyncer.r2dbc.mysql.codec.ShortCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class LongCodec
extends AbstractPrimitiveCodec<Long> {
    static final LongCodec INSTANCE = new LongCodec();

    private LongCodec() {
        super(Long.TYPE, Long.class);
    }

    @Override
    public Long decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        MySqlType type = metadata.getType();
        if (binary) {
            return LongCodec.decodeBinary(value, type);
        }
        switch (type) {
            case FLOAT: {
                return (long)Float.parseFloat(value.toString(StandardCharsets.US_ASCII));
            }
            case DOUBLE: {
                return (long)Double.parseDouble(value.toString(StandardCharsets.US_ASCII));
            }
            case DECIMAL: {
                return LongCodec.decimalLong(value);
            }
        }
        return CodecUtils.parseLong(value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Long;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return LongCodec.encodeLong((Long)value);
    }

    @Override
    public boolean doCanDecode(MySqlReadableMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    static MySqlParameter encodeLong(long v) {
        if ((long)((byte)v) == v) {
            return new ByteCodec.ByteMySqlParameter((byte)v);
        }
        if ((long)((short)v) == v) {
            return new ShortCodec.ShortMySqlParameter((short)v);
        }
        if ((long)((int)v) == v) {
            return new IntegerCodec.IntMySqlParameter((int)v);
        }
        return new LongMySqlParameter(v);
    }

    private static long decodeBinary(ByteBuf buf, MySqlType type) {
        switch (type) {
            case BIGINT_UNSIGNED: 
            case BIGINT: {
                return buf.readLongLE();
            }
            case INT_UNSIGNED: {
                return buf.readUnsignedIntLE();
            }
            case INT: 
            case MEDIUMINT_UNSIGNED: 
            case MEDIUMINT: {
                return buf.readIntLE();
            }
            case SMALLINT_UNSIGNED: {
                return buf.readUnsignedShortLE();
            }
            case SMALLINT: 
            case YEAR: {
                return buf.readShortLE();
            }
            case TINYINT_UNSIGNED: {
                return buf.readUnsignedByte();
            }
            case TINYINT: {
                return buf.readByte();
            }
            case DECIMAL: {
                return LongCodec.decimalLong(buf);
            }
            case FLOAT: {
                return (long)buf.readFloatLE();
            }
            case DOUBLE: {
                return (long)buf.readDoubleLE();
            }
        }
        throw new IllegalStateException("Cannot decode type " + (Object)((Object)type) + " as a Long");
    }

    private static long decimalLong(ByteBuf buf) {
        return new BigDecimal(buf.toString(StandardCharsets.US_ASCII)).longValue();
    }

    private static final class LongMySqlParameter
    extends AbstractMySqlParameter {
        private final long value;

        private LongMySqlParameter(long value) {
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> allocator.buffer(8).writeLongLE(this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeLong(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.BIGINT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LongMySqlParameter)) {
                return false;
            }
            LongMySqlParameter longValue = (LongMySqlParameter)o;
            return this.value == longValue.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        @Override
        public String toString() {
            return Long.toString(this.value);
        }
    }
}

