/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import reactor.core.publisher.SynchronousSink;

final class CreateSavepointState
extends AbstractTransactionState {
    private static final int START_TRANSACTION = 1;
    private static final int CREATE_SAVEPOINT = 2;
    private final String name;

    CreateSavepointState(Client client, String name) {
        super(client);
        this.name = name;
    }

    @Override
    boolean cancelTasks() {
        if (!this.client.getContext().isInTransaction()) {
            this.tasks |= 1;
            this.statements.add("BEGIN");
        }
        String doneSql = "SAVEPOINT " + StringUtils.quoteIdentifier(this.name);
        this.tasks |= 2;
        this.statements.add(doneSql);
        return false;
    }

    @Override
    protected boolean process(int task, SynchronousSink<Void> sink) {
        switch (task) {
            case 1: {
                return true;
            }
            case 2: {
                sink.complete();
                return false;
            }
        }
        sink.error((Throwable)new IllegalStateException("Undefined transaction task: " + task + ", remain: " + this.tasks));
        return false;
    }
}

