/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import reactor.core.publisher.SynchronousSink;

final class CommitRollbackState
extends AbstractTransactionState {
    private static final int LOCK_WAIT_TIMEOUT = 1;
    private static final int COMMIT_OR_ROLLBACK = 2;
    private static final int CANCEL = 4;
    private final boolean commit;

    CommitRollbackState(Client client, boolean commit) {
        super(client);
        this.commit = commit;
    }

    @Override
    boolean cancelTasks() {
        ConnectionContext context = this.client.getContext();
        if (!context.isInTransaction()) {
            this.tasks |= 4;
            return true;
        }
        if (context.isLockWaitTimeoutChanged()) {
            this.tasks |= 1;
            this.statements.add(StringUtils.lockWaitTimeoutStatement(context.getSessionLockWaitTimeout()));
        }
        this.tasks |= 2;
        String doneSql = this.commit ? "COMMIT" : "ROLLBACK";
        this.statements.add(doneSql);
        return false;
    }

    @Override
    protected boolean process(int task, SynchronousSink<Void> sink) {
        switch (task) {
            case 1: {
                this.client.getContext().resetCurrentLockWaitTimeout();
                return true;
            }
            case 2: {
                this.client.getContext().resetCurrentIsolationLevel();
                sink.complete();
                return false;
            }
            case 4: {
                sink.complete();
                return false;
            }
        }
        sink.error((Throwable)new IllegalStateException("Undefined commit task: " + task + ", remain: " + this.tasks));
        return false;
    }
}

