/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.AreaUnitType;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConvertAreaUnit;
import io.atlasmap.v2.ConvertDistanceUnit;
import io.atlasmap.v2.ConvertMassUnit;
import io.atlasmap.v2.ConvertVolumeUnit;
import io.atlasmap.v2.DistanceUnitType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.MassUnitType;
import io.atlasmap.v2.NumberType;
import io.atlasmap.v2.SumUp;
import io.atlasmap.v2.VolumeUnitType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class NumberFieldActions
implements AtlasFieldAction {
    private static final double KILO_GRAMS_IN_A_POUND = 0.45359237;
    private static final double YARDS_IN_A_MILE = 1760.0;
    private static final double FEET_IN_A_YARD = 3.0;
    private static final double INCHES_IN_A_FOOT = 12.0;
    private static final double METERS_IN_A_INCH = 0.0254;
    private static final double SQUARE_FEET_IN_A_SQUARE_METER = Math.pow(3.2808398950131235, 2.0);
    private static final double SQUARE_METERS_IN_A_SQUARE_MILE = Math.pow(1609.3439999999998, 2.0);
    private static final double SQUARE_FEET_IN_A_SQUARE_MILE = Math.pow(5280.0, 2.0);
    private static final double LITTERS_IN_A_CUBIC_METER = 1000.0;
    private static final double CUBIC_FEET_IN_A_CUBIC_METER = Math.pow(3.2808398950131235, 3.0);
    private static final double GALLONS_US_FLUID_IN_A_CUBIC_METER = 264.17205236;
    private static Map<MassUnitType, Map<MassUnitType, Double>> massConvertionTable;
    private static Map<DistanceUnitType, Map<DistanceUnitType, Double>> distanceConvertionTable;
    private static Map<AreaUnitType, Map<AreaUnitType, Double>> areaConvertionTable;
    private static Map<VolumeUnitType, Map<VolumeUnitType, Double>> volumeConvertionTable;

    @AtlasFieldActionInfo(name="ConvertMassUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertMassUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertMassUnit) || ((ConvertMassUnit)action).getFromUnit() == null || ((ConvertMassUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertMassUnit must be specfied  with fromUnit and toUnit");
        }
        MassUnitType fromUnit = ((ConvertMassUnit)action).getFromUnit();
        MassUnitType toUnit = ((ConvertMassUnit)action).getToUnit();
        double rate = massConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasFieldActionInfo(name="ConvertDistanceUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertDistanceUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertDistanceUnit) || ((ConvertDistanceUnit)action).getFromUnit() == null || ((ConvertDistanceUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertDistanceUnit must be specfied  with fromUnit and toUnit");
        }
        DistanceUnitType fromUnit = ((ConvertDistanceUnit)action).getFromUnit();
        DistanceUnitType toUnit = ((ConvertDistanceUnit)action).getToUnit();
        double rate = distanceConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasFieldActionInfo(name="ConvertAreaUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertAreaUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertAreaUnit) || ((ConvertAreaUnit)action).getFromUnit() == null || ((ConvertAreaUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertAreaUnit must be specfied  with fromUnit and toUnit");
        }
        AreaUnitType fromUnit = ((ConvertAreaUnit)action).getFromUnit();
        AreaUnitType toUnit = ((ConvertAreaUnit)action).getToUnit();
        double rate = areaConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasFieldActionInfo(name="ConvertVolumeUnit", sourceType=FieldType.NUMBER, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.NONE, targetCollectionType=CollectionType.NONE)
    public static Number convertVolumeUnit(Action action, Number input) {
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof ConvertVolumeUnit) || ((ConvertVolumeUnit)action).getFromUnit() == null || ((ConvertVolumeUnit)action).getToUnit() == null) {
            throw new IllegalArgumentException("ConvertVolumeUnit must be specfied  with fromUnit and toUnit");
        }
        VolumeUnitType fromUnit = ((ConvertVolumeUnit)action).getFromUnit();
        VolumeUnitType toUnit = ((ConvertVolumeUnit)action).getToUnit();
        double rate = volumeConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    private static Number doMultiply(Number input, double rate) {
        if (input instanceof BigDecimal) {
            return ((BigDecimal)input).multiply(new BigDecimal(rate));
        }
        if (input instanceof Double) {
            return (Double)input * rate;
        }
        if (input instanceof Float) {
            return Float.valueOf((float)((double)((Float)input).floatValue() * rate));
        }
        if (input instanceof Long) {
            return (long)((double)((Long)input).longValue() * rate);
        }
        if (input instanceof AtomicLong) {
            return (long)((double)((AtomicLong)input).get() * rate);
        }
        if (input instanceof Integer) {
            return (int)((double)((Integer)input).intValue() * rate);
        }
        if (input instanceof AtomicInteger) {
            return (int)((double)((AtomicInteger)input).get() * rate);
        }
        if (input instanceof Byte) {
            return (byte)((double)((Byte)input).byteValue() * rate);
        }
        return Double.parseDouble(input.toString()) * rate;
    }

    @AtlasFieldActionInfo(name="SumUp", sourceType=FieldType.COMPLEX, targetType=FieldType.NUMBER, sourceCollectionType=CollectionType.ALL, targetCollectionType=CollectionType.NONE)
    public static Number sumUp(Action action, Object input) {
        Object binList;
        Object inputs;
        if (input == null) {
            return 0;
        }
        if (action == null || !(action instanceof SumUp)) {
            throw new IllegalArgumentException("SumUp must be specfied as an action");
        }
        SumUp sumup = (SumUp)action;
        NumberType numberType = sumup.getNumberType();
        if (input instanceof Iterable) {
            inputs = (Collection)input;
        } else if (input instanceof Map) {
            inputs = ((Map)input).values();
        } else if (input instanceof Number[]) {
            inputs = Arrays.asList((Number[])input);
        } else if (input instanceof double[]) {
            double[] din = (double[])input;
            ArrayList dinList = new ArrayList(din.length);
            for (double e : din) {
                dinList.add(e);
            }
            if (numberType == null) {
                numberType = NumberType.DOUBLE;
            }
            inputs = dinList;
        } else if (input instanceof float[]) {
            float[] fin = (float[])input;
            ArrayList finList = new ArrayList(fin.length);
            for (float e : fin) {
                finList.add(Float.valueOf(e));
            }
            if (numberType == null) {
                numberType = NumberType.FLOAT;
            }
            inputs = finList;
        } else if (input instanceof long[]) {
            long[] lin = (long[])input;
            ArrayList linList = new ArrayList(lin.length);
            for (long e : lin) {
                linList.add(e);
            }
            if (numberType == null) {
                numberType = NumberType.LONG;
            }
            inputs = linList;
        } else if (input instanceof int[]) {
            int[] iin = (int[])input;
            ArrayList iinList = new ArrayList(iin.length);
            for (int e : iin) {
                iinList.add(e);
            }
            if (numberType == null) {
                numberType = NumberType.INTEGER;
            }
            inputs = iinList;
        } else if (input instanceof byte[]) {
            byte[] bin = (byte[])input;
            binList = new ArrayList(bin.length);
            for (byte e : bin) {
                binList.add(e);
            }
            if (numberType == null) {
                numberType = NumberType.BYTE;
            }
            inputs = binList;
        } else {
            throw new IllegalArgumentException("Illegal input[" + input + "] it must be a Collection, Map or array of numbers");
        }
        if (numberType == null) {
            Object e = inputs.iterator().next();
            numberType = e instanceof BigDecimal ? NumberType.DECIMAL : (e instanceof Float ? NumberType.FLOAT : (e instanceof Long ? NumberType.LONG : (e instanceof Integer ? NumberType.INTEGER : (e instanceof Byte ? NumberType.BYTE : NumberType.DOUBLE))));
        }
        switch (numberType) {
            case BYTE: {
                byte b = 0;
                binList = inputs.iterator();
                while (binList.hasNext()) {
                    Object t = binList.next();
                    if (t instanceof Number) {
                        b = (byte)(b + ((Number)t).byteValue());
                        continue;
                    }
                    b = (byte)(b + Byte.parseByte(t.toString()));
                }
                return b;
            }
            case DECIMAL: {
                BigDecimal bd = new BigDecimal(0);
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    Object entry2 = iterator.next();
                    if (entry2 instanceof BigDecimal) {
                        bd.add((BigDecimal)entry2);
                        continue;
                    }
                    if (entry2 instanceof Number) {
                        double dentry = ((Number)entry2).doubleValue();
                        bd.add(new BigDecimal(dentry));
                        continue;
                    }
                    bd.add(new BigDecimal(entry2.toString()));
                }
                return bd;
            }
            case DOUBLE: {
                double d = 0.0;
                Iterator dentry = inputs.iterator();
                while (dentry.hasNext()) {
                    Object entry = dentry.next();
                    if (entry instanceof Number) {
                        d += ((Number)entry).doubleValue();
                        continue;
                    }
                    d += Double.parseDouble(entry.toString());
                }
                return d;
            }
            case FLOAT: {
                float f = 0.0f;
                Iterator entry = inputs.iterator();
                while (entry.hasNext()) {
                    Object entry3 = entry.next();
                    if (entry3 instanceof Number) {
                        f += ((Number)entry3).floatValue();
                        continue;
                    }
                    f += Float.parseFloat(entry3.toString());
                }
                return Float.valueOf(f);
            }
            case INTEGER: {
                int i = 0;
                Iterator entry3 = inputs.iterator();
                while (entry3.hasNext()) {
                    Object entry = entry3.next();
                    if (entry instanceof Number) {
                        i += ((Number)entry).intValue();
                        continue;
                    }
                    i += Integer.parseInt(entry.toString());
                }
                return i;
            }
            case LONG: {
                long l = 0L;
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    Object entry = iterator.next();
                    if (entry instanceof Number) {
                        l += ((Number)entry).longValue();
                        continue;
                    }
                    l += Long.parseLong(entry.toString());
                }
                return l;
            }
            case SHORT: {
                short s = 0;
                Iterator iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    Object entry = iterator.next();
                    if (entry instanceof Number) {
                        s = (short)(s + ((Number)entry).shortValue());
                        continue;
                    }
                    s = (short)(s + Short.parseShort(entry.toString()));
                }
                return s;
            }
        }
        throw new IllegalArgumentException("Unsupported number type: " + numberType);
    }

    static {
        HashMap rootTable = new HashMap();
        HashMap<MassUnitType, Double> kgRates = new HashMap<MassUnitType, Double>();
        kgRates.put(MassUnitType.KILO_GRAM, 1.0);
        kgRates.put(MassUnitType.POUND, 2.2046226218487757);
        rootTable.put(MassUnitType.KILO_GRAM, Collections.unmodifiableMap(kgRates));
        HashMap<MassUnitType, Double> lbsRates = new HashMap<MassUnitType, Double>();
        lbsRates.put(MassUnitType.KILO_GRAM, 0.45359237);
        lbsRates.put(MassUnitType.POUND, 1.0);
        rootTable.put(MassUnitType.POUND, Collections.unmodifiableMap(lbsRates));
        massConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new HashMap();
        HashMap<DistanceUnitType, Double> mRates = new HashMap<DistanceUnitType, Double>();
        mRates.put(DistanceUnitType.METER, 1.0);
        mRates.put(DistanceUnitType.FOOT, 3.2808398950131235);
        mRates.put(DistanceUnitType.YARD, 1.0936132983377078);
        mRates.put(DistanceUnitType.MILE, 6.21371192237334E-4);
        mRates.put(DistanceUnitType.INCH, 39.37007874015748);
        rootTable.put(DistanceUnitType.METER, Collections.unmodifiableMap(mRates));
        HashMap<DistanceUnitType, Double> ftRates = new HashMap<DistanceUnitType, Double>();
        ftRates.put(DistanceUnitType.METER, 0.30479999999999996);
        ftRates.put(DistanceUnitType.FOOT, 1.0);
        ftRates.put(DistanceUnitType.YARD, 0.3333333333333333);
        ftRates.put(DistanceUnitType.MILE, 1.893939393939394E-4);
        ftRates.put(DistanceUnitType.INCH, 12.0);
        rootTable.put(DistanceUnitType.FOOT, Collections.unmodifiableMap(ftRates));
        HashMap<DistanceUnitType, Double> ydRates = new HashMap<DistanceUnitType, Double>();
        ydRates.put(DistanceUnitType.METER, 0.9144);
        ydRates.put(DistanceUnitType.FOOT, 3.0);
        ydRates.put(DistanceUnitType.YARD, 1.0);
        ydRates.put(DistanceUnitType.MILE, 5.681818181818182E-4);
        ydRates.put(DistanceUnitType.INCH, 36.0);
        rootTable.put(DistanceUnitType.YARD, Collections.unmodifiableMap(ydRates));
        HashMap<DistanceUnitType, Double> miRates = new HashMap<DistanceUnitType, Double>();
        miRates.put(DistanceUnitType.METER, 1609.3439999999998);
        miRates.put(DistanceUnitType.FOOT, 5280.0);
        miRates.put(DistanceUnitType.YARD, 1760.0);
        miRates.put(DistanceUnitType.MILE, 1.0);
        miRates.put(DistanceUnitType.INCH, 63360.0);
        rootTable.put(DistanceUnitType.MILE, Collections.unmodifiableMap(miRates));
        HashMap<DistanceUnitType, Double> inRates = new HashMap<DistanceUnitType, Double>();
        inRates.put(DistanceUnitType.METER, 0.0254);
        inRates.put(DistanceUnitType.FOOT, 0.08333333333333333);
        inRates.put(DistanceUnitType.YARD, 0.027777777777777776);
        inRates.put(DistanceUnitType.MILE, 1.5782828282828283E-5);
        inRates.put(DistanceUnitType.INCH, 1.0);
        rootTable.put(DistanceUnitType.INCH, Collections.unmodifiableMap(inRates));
        distanceConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new HashMap();
        HashMap<AreaUnitType, Double> m2Rates = new HashMap<AreaUnitType, Double>();
        m2Rates.put(AreaUnitType.SQUARE_METER, 1.0);
        m2Rates.put(AreaUnitType.SQUARE_FOOT, SQUARE_FEET_IN_A_SQUARE_METER);
        m2Rates.put(AreaUnitType.SQUARE_MILE, 1.0 / SQUARE_METERS_IN_A_SQUARE_MILE);
        rootTable.put(AreaUnitType.SQUARE_METER, Collections.unmodifiableMap(m2Rates));
        HashMap<AreaUnitType, Double> ft2Rates = new HashMap<AreaUnitType, Double>();
        ft2Rates.put(AreaUnitType.SQUARE_METER, 1.0 / SQUARE_FEET_IN_A_SQUARE_METER);
        ft2Rates.put(AreaUnitType.SQUARE_FOOT, 1.0);
        ft2Rates.put(AreaUnitType.SQUARE_MILE, 1.0 / SQUARE_FEET_IN_A_SQUARE_MILE);
        rootTable.put(AreaUnitType.SQUARE_FOOT, Collections.unmodifiableMap(ft2Rates));
        HashMap<AreaUnitType, Double> mi2Rates = new HashMap<AreaUnitType, Double>();
        mi2Rates.put(AreaUnitType.SQUARE_METER, SQUARE_METERS_IN_A_SQUARE_MILE);
        mi2Rates.put(AreaUnitType.SQUARE_FOOT, SQUARE_FEET_IN_A_SQUARE_MILE);
        mi2Rates.put(AreaUnitType.SQUARE_MILE, 1.0);
        rootTable.put(AreaUnitType.SQUARE_MILE, Collections.unmodifiableMap(mi2Rates));
        areaConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new HashMap();
        HashMap<VolumeUnitType, Double> m3Rates = new HashMap<VolumeUnitType, Double>();
        m3Rates.put(VolumeUnitType.CUBIC_METER, 1.0);
        m3Rates.put(VolumeUnitType.LITTER, 1000.0);
        m3Rates.put(VolumeUnitType.CUBIC_FOOT, CUBIC_FEET_IN_A_CUBIC_METER);
        m3Rates.put(VolumeUnitType.GALLON_US_FLUID, 264.17205236);
        rootTable.put(VolumeUnitType.CUBIC_METER, Collections.unmodifiableMap(m3Rates));
        HashMap<VolumeUnitType, Double> litterRates = new HashMap<VolumeUnitType, Double>();
        litterRates.put(VolumeUnitType.CUBIC_METER, 0.001);
        litterRates.put(VolumeUnitType.LITTER, 1.0);
        litterRates.put(VolumeUnitType.CUBIC_FOOT, 0.001 * CUBIC_FEET_IN_A_CUBIC_METER);
        litterRates.put(VolumeUnitType.GALLON_US_FLUID, 0.26417205236);
        rootTable.put(VolumeUnitType.LITTER, Collections.unmodifiableMap(litterRates));
        HashMap<VolumeUnitType, Double> cftRates = new HashMap<VolumeUnitType, Double>();
        cftRates.put(VolumeUnitType.CUBIC_METER, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER);
        cftRates.put(VolumeUnitType.LITTER, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER * 1000.0);
        cftRates.put(VolumeUnitType.CUBIC_FOOT, 1.0);
        cftRates.put(VolumeUnitType.GALLON_US_FLUID, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER * 264.17205236);
        rootTable.put(VolumeUnitType.CUBIC_FOOT, Collections.unmodifiableMap(cftRates));
        HashMap<VolumeUnitType, Double> galUsFluidRates = new HashMap<VolumeUnitType, Double>();
        galUsFluidRates.put(VolumeUnitType.CUBIC_METER, 0.003785411783973468);
        galUsFluidRates.put(VolumeUnitType.LITTER, 3.785411783973468);
        galUsFluidRates.put(VolumeUnitType.CUBIC_FOOT, 0.003785411783973468 * CUBIC_FEET_IN_A_CUBIC_METER);
        galUsFluidRates.put(VolumeUnitType.GALLON_US_FLUID, 1.0);
        rootTable.put(VolumeUnitType.GALLON_US_FLUID, Collections.unmodifiableMap(galUsFluidRates));
        volumeConvertionTable = Collections.unmodifiableMap(rootTable);
    }
}

