/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class FloatConverter
implements AtlasPrimitiveConverter<Float> {
    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.RANGE})
    public Boolean convertToBoolean(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if ((double)value.floatValue() == 0.0 || (double)value.floatValue() == 1.0) {
            if (value.floatValue() == 1.0f) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw new AtlasConversionException(String.format("Float %s could not be converted to a Boolean", value));
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.UNSUPPORTED})
    public Byte convertToByte(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException("Float to Byte conversion is not supported"));
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE})
    public Character convertToCharacter(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < 0.0f || value.floatValue() > 65535.0f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Character.MAX_VALUE or is less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() == 0.0f) {
            return value.doubleValue();
        }
        return value.doubleValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.FLOAT)
    public Float convertToFloat(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.RANGE})
    public Integer convertToInteger(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() < -2.1474836E9f || value.floatValue() > 2.1474836E9f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Integer.MAX_VALUE or is less than Integer.MIN_VALUE", value));
        }
        return value.intValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.LONG, concerns={AtlasConversionConcern.RANGE})
    public Long convertToLong(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() > 9.223372E18f || value.floatValue() < -9.223372E18f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Long.MAX_VALUE or is less than Long.MIN_VALUE", value));
        }
        return value.longValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short convertToShort(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() > 32767.0f || value.floatValue() < -32768.0f) {
            throw new AtlasConversionException(String.format("Float %s is greater than Short.MAX_VALUE  or is less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.FLOAT, targetType=FieldType.STRING)
    public String convertToString(Float value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

