/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class IntegerConverter
implements AtlasPrimitiveConverter<Integer> {
    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.RANGE})
    public Boolean convertToBoolean(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value == 0 || value == 1) {
            return value == 1;
        }
        throw new AtlasConversionException(String.format("Integer %s cannot be converted to a Boolean", value));
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.UNSUPPORTED})
    public Byte convertToByte(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException("Integer to Byte conversion is not supported"));
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE})
    public Character convertToCharacter(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value < 0 || value > 65535) {
            throw new AtlasConversionException(String.format("Integer %s is greater than Character.MAX_VALUE or less than Character.MIN_VALUE", value));
        }
        int radix = 10;
        return Character.valueOf(Character.forDigit(value, 10));
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.doubleValue() == 0.0 || value.doubleValue() == -0.0) {
            return value.doubleValue();
        }
        return value.doubleValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.FLOAT, concerns={AtlasConversionConcern.RANGE})
    public Float convertToFloat(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.floatValue() == 0.0f || value.floatValue() == -0.0f) {
            return Float.valueOf(value.floatValue());
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.INTEGER)
    public Integer convertToInteger(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (int)value;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.LONG)
    public Long convertToLong(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short convertToShort(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new AtlasConversionException(String.format("Integer %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.STRING)
    public String convertToString(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

