/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;

public class StringConverter
implements AtlasPrimitiveConverter<String> {
    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.RANGE})
    public Boolean convertToBoolean(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.equals("0") || value.equalsIgnoreCase("f") || value.equals("false")) {
            return Boolean.FALSE;
        }
        if (value.equals("1") || value.equalsIgnoreCase("t") || value.equals("true")) {
            return Boolean.TRUE;
        }
        throw new AtlasConversionException(String.format("String %s cannot be converted to a Boolean", value));
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.UNSUPPORTED})
    public Byte convertToByte(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException("String to Byte conversion is not supported"));
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE})
    public Character convertToCharacter(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.isEmpty() || value.length() > 1) {
            throw new AtlasConversionException("String is either empty or greater than one character long");
        }
        if (value.charAt(0) < '\u0000' || value.charAt(0) > '\uffff') {
            throw new AtlasConversionException(String.format("String %s is greater than Character.MAX_VALUE  or less than Character.MIN_VALUE", value));
        }
        return Character.valueOf(value.charAt(0));
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.DOUBLE, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE})
    public Double convertToDouble(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new AtlasConversionException((Throwable)nfe);
        }
        if (Double.valueOf(value) == 0.0 || Double.valueOf(value) == -0.0) {
            return Double.valueOf(value);
        }
        if (Double.valueOf(value) < Double.MIN_VALUE || Double.valueOf(value) > Double.MAX_VALUE) {
            throw new AtlasConversionException(String.format("String %s is greater than Double.MAX_VALUE  or less than Double.MIN_VALUE", value));
        }
        return Double.valueOf(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.FLOAT, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE})
    public Float convertToFloat(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        try {
            Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            throw new AtlasConversionException((Throwable)nfe);
        }
        BigDecimal bd = new BigDecimal(value);
        if (bd.floatValue() == 0.0f || (double)bd.floatValue() == -0.0) {
            return Float.valueOf(value);
        }
        if (bd.floatValue() < Float.MIN_VALUE || bd.floatValue() > Float.MAX_VALUE) {
            throw new AtlasConversionException(String.format("String %s is greater than Float.MAX_VALUE  or less than Float.MIN_VALUE", value));
        }
        return Float.valueOf(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.INTEGER, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE})
    public Integer convertToInteger(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        BigDecimal bd = null;
        Integer i = null;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            try {
                bd = new BigDecimal(value);
                i = bd.intValue();
            }
            catch (NumberFormatException nfe2) {
                throw new AtlasConversionException((Throwable)nfe);
            }
        }
        if (bd != null && bd.compareTo(BigDecimal.valueOf(i.intValue())) != 0) {
            throw new AtlasConversionException(String.format("String %s is greater than Integer.MAX_VALUE  or less than Integer.MIN_VALUE", value));
        }
        return i;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.LONG, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE})
    public Long convertToLong(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        BigDecimal bd = null;
        Long l = null;
        try {
            l = Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            try {
                bd = new BigDecimal(value);
                l = bd.longValue();
            }
            catch (NumberFormatException nfe2) {
                throw new AtlasConversionException((Throwable)nfe);
            }
        }
        if (bd != null && bd.compareTo(BigDecimal.valueOf(l)) != 0) {
            throw new AtlasConversionException(String.format("String %s is greater than Long.MAX_VALUE  or less than Long.MIN_VALUE", value));
        }
        return l;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.FORMAT, AtlasConversionConcern.RANGE})
    public Short convertToShort(String value) throws AtlasConversionException {
        Short shortty;
        if (value == null) {
            return null;
        }
        try {
            shortty = Short.parseShort(value);
        }
        catch (NumberFormatException nfe) {
            throw new AtlasConversionException((Throwable)nfe);
        }
        return (short)shortty;
    }

    @AtlasConversionInfo(sourceType=FieldType.STRING, targetType=FieldType.STRING)
    public String convertToString(String value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return new String(value);
    }
}

