/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import java.util.ArrayList;
import java.util.List;

public class AtlasPath {
    public static final String JAVAPATH_SEPARATOR = ".";
    public static final String JAVAPATH_SEPARATOR_ESCAPTED = "\\.";
    public static final String JAVAPATH_ARRAY_START = "[";
    public static final String JAVAPATH_ARRAY_END = "]";
    public static final String JAVAPATH_LIST_START = "<";
    public static final String JAVAPATH_LIST_END = ">";
    public static final String JAVAPATH_MAP_START = "{";
    public static final String JAVAPATH_MAP_END = "}";
    private List<String> segments = new ArrayList<String>();

    public AtlasPath() {
    }

    public AtlasPath(String javaPath) {
        if (javaPath != null) {
            if (javaPath.contains(JAVAPATH_SEPARATOR)) {
                String[] parts;
                for (String part : parts = javaPath.split(JAVAPATH_SEPARATOR_ESCAPTED, 512)) {
                    this.getSegments().add(part);
                }
            } else {
                this.getSegments().add(javaPath);
            }
        }
    }

    public AtlasPath appendField(String fieldName) {
        this.segments.add(fieldName);
        return this;
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String getLastSegment() {
        if (this.segments.size() > 0) {
            return this.segments.get(this.segments.size() - 1);
        }
        return null;
    }

    public boolean hasParent() {
        return this.segments.size() > 1;
    }

    public boolean hasCollection() {
        for (String seg : this.getSegments()) {
            if (!AtlasPath.isCollectionSegment(seg).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean isIndexedCollection() {
        for (String seg : this.getSegments()) {
            if (!AtlasPath.isCollectionSegment(seg).booleanValue() || AtlasPath.indexOfSegment(seg) == null) continue;
            return true;
        }
        return false;
    }

    public Boolean isCollectionRoot() {
        return AtlasPath.isCollectionSegment(this.getLastSegment());
    }

    public String getLastSegmentParent() {
        if (this.segments.size() == 0 || this.segments.size() == 1) {
            return null;
        }
        return this.segments.get(this.segments.size() - 2);
    }

    public AtlasPath getLastSegmentParentPath() {
        if (this.segments.size() == 0 || this.segments.size() == 1) {
            return null;
        }
        AtlasPath parentPath = new AtlasPath();
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            parentPath.appendField(this.segments.get(i));
        }
        return parentPath;
    }

    public AtlasPath deCollectionify(String collectionSegment) {
        if (this.segments.size() == 0 || this.segments.size() == 1) {
            return null;
        }
        AtlasPath j = new AtlasPath();
        boolean collectionFound = false;
        for (String part : this.segments) {
            if (collectionFound) {
                j.appendField(part);
            }
            if (!AtlasPath.cleanPathSegment(part).equals(AtlasPath.cleanPathSegment(collectionSegment))) continue;
            collectionFound = true;
        }
        return j;
    }

    public AtlasPath deParentify() {
        if (this.segments.size() == 0 || this.segments.size() == 1) {
            return null;
        }
        AtlasPath j = new AtlasPath();
        for (int i = 1; i < this.segments.size(); ++i) {
            j.appendField(this.segments.get(i));
        }
        return j;
    }

    public static String cleanPathSegment(String pathSegment) {
        if (pathSegment == null) {
            return null;
        }
        if (pathSegment.contains(JAVAPATH_ARRAY_START) && pathSegment.endsWith(JAVAPATH_ARRAY_END)) {
            return pathSegment.substring(0, pathSegment.indexOf(JAVAPATH_ARRAY_START, 0));
        }
        if (pathSegment.contains(JAVAPATH_LIST_START) && pathSegment.endsWith(JAVAPATH_LIST_END)) {
            return pathSegment.substring(0, pathSegment.indexOf(JAVAPATH_LIST_START, 0));
        }
        if (pathSegment.contains(JAVAPATH_MAP_START) && pathSegment.endsWith(JAVAPATH_MAP_END)) {
            return pathSegment.substring(0, pathSegment.indexOf(JAVAPATH_MAP_START, 0));
        }
        return pathSegment;
    }

    public static Boolean isCollectionSegment(String pathSegment) {
        if (pathSegment == null) {
            return false;
        }
        if (pathSegment.contains(JAVAPATH_ARRAY_START) && pathSegment.endsWith(JAVAPATH_ARRAY_END)) {
            return true;
        }
        if (pathSegment.contains(JAVAPATH_LIST_START) && pathSegment.endsWith(JAVAPATH_LIST_END)) {
            return true;
        }
        if (pathSegment.contains(JAVAPATH_MAP_START) && pathSegment.endsWith(JAVAPATH_MAP_END)) {
            return true;
        }
        return false;
    }

    public static Integer indexOfSegment(String pathSegment) {
        if (pathSegment == null) {
            return null;
        }
        if (pathSegment.contains(JAVAPATH_ARRAY_START) && pathSegment.endsWith(JAVAPATH_ARRAY_END)) {
            int start = pathSegment.indexOf(JAVAPATH_ARRAY_START, 0) + 1;
            String index = pathSegment.substring(start, pathSegment.indexOf(JAVAPATH_ARRAY_END, start));
            if (index != null && index.length() > 0) {
                return Integer.valueOf(index);
            }
            return null;
        }
        if (pathSegment.contains(JAVAPATH_LIST_START) && pathSegment.endsWith(JAVAPATH_LIST_END)) {
            int start = pathSegment.indexOf(JAVAPATH_LIST_START, 0) + 1;
            String index = pathSegment.substring(start, pathSegment.indexOf(JAVAPATH_LIST_END, start));
            if (index != null && index.length() > 0) {
                return Integer.valueOf(index);
            }
            return null;
        }
        return null;
    }

    public Integer getCollectionIndex(String segment) {
        for (String part : this.getSegments()) {
            if (!AtlasPath.cleanPathSegment(part).equals(AtlasPath.cleanPathSegment(segment)) || (!part.contains(JAVAPATH_ARRAY_START) || !part.contains(JAVAPATH_ARRAY_END)) && (!part.contains(JAVAPATH_LIST_START) || !part.contains(JAVAPATH_LIST_END))) continue;
            return AtlasPath.indexOfSegment(part);
        }
        return null;
    }

    public String getCollectionSegment() {
        for (String part : this.getSegments()) {
            if (!AtlasPath.isCollectionSegment(part).booleanValue()) continue;
            return part;
        }
        return null;
    }

    public void setCollectionIndex(String segment, Integer index) {
        if (segment == null) {
            throw new IllegalArgumentException("JavaPath segment cannot be null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("JavaPath index must be a positive integer");
        }
        if (segment.contains(JAVAPATH_ARRAY_START) && segment.contains(JAVAPATH_ARRAY_END)) {
            for (int i = 0; i < this.getSegments().size(); ++i) {
                String part = this.getSegments().get(i);
                if (!AtlasPath.cleanPathSegment(part).equals(AtlasPath.cleanPathSegment(segment))) continue;
                this.getSegments().set(i, AtlasPath.cleanPathSegment(segment) + JAVAPATH_ARRAY_START + index + JAVAPATH_ARRAY_END);
            }
        } else if (segment.contains(JAVAPATH_LIST_START) && segment.contains(JAVAPATH_LIST_END)) {
            for (int i = 0; i < this.getSegments().size(); ++i) {
                String part = this.getSegments().get(i);
                if (!AtlasPath.cleanPathSegment(part).equals(AtlasPath.cleanPathSegment(segment))) continue;
                this.getSegments().set(i, AtlasPath.cleanPathSegment(segment) + JAVAPATH_LIST_START + index + JAVAPATH_LIST_END);
            }
        } else {
            throw new IllegalArgumentException("JavaPath segment is not a List or Array segment");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (String part : this.getSegments()) {
            buffer.append(part);
            if (i < this.getSegments().size() - 1) {
                buffer.append(JAVAPATH_SEPARATOR);
            }
            ++i;
        }
        return buffer.toString();
    }
}

