/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasFieldActionService;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.PathUtil;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseAtlasModule
implements AtlasModule {
    private static final Logger logger = LoggerFactory.getLogger(BaseAtlasModule.class);
    private AtlasConversionService atlasConversionService = null;
    private AtlasModuleMode atlasModuleMode = AtlasModuleMode.UNSET;
    protected boolean automaticallyProcessOutputFieldActions = true;

    public void init() {
    }

    public void destroy() {
    }

    public void processInputActions(AtlasSession atlasSession, BaseMapping baseMapping) throws AtlasException {
        if (baseMapping.getMappingType().equals((Object)MappingType.COLLECTION)) {
            return;
        }
        AtlasFieldActionService fieldActionService = atlasSession.getAtlasContext().getContextFactory().getFieldActionService();
        Mapping mapping = (Mapping)baseMapping;
        for (Field field : mapping.getInputField()) {
            this.processFieldActions(fieldActionService, field);
        }
    }

    public void processOutputActions(AtlasSession atlasSession, BaseMapping baseMapping) throws AtlasException {
        if (!this.automaticallyProcessOutputFieldActions) {
            return;
        }
        if (baseMapping.getMappingType().equals((Object)MappingType.COLLECTION)) {
            return;
        }
        AtlasFieldActionService fieldActionService = atlasSession.getAtlasContext().getContextFactory().getFieldActionService();
        Mapping mapping = (Mapping)baseMapping;
        for (Field field : mapping.getOutputField()) {
            this.processFieldActions(fieldActionService, field);
        }
    }

    public abstract int getCollectionSize(AtlasSession var1, Field var2) throws AtlasException;

    public abstract Field cloneField(Field var1) throws AtlasException;

    public List<Mapping> generateInputMappings(AtlasSession session, BaseMapping baseMapping) throws AtlasException {
        if (logger.isDebugEnabled()) {
            logger.debug("Generating Input Mappings from mapping: " + baseMapping);
        }
        if (!baseMapping.getMappingType().equals((Object)MappingType.COLLECTION)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Mapping is not a collection mapping, not cloning: " + baseMapping);
            }
            return Arrays.asList((Mapping)baseMapping);
        }
        LinkedList<Mapping> mappings = new LinkedList<Mapping>();
        for (BaseMapping m : ((Collection)baseMapping).getMappings().getMapping()) {
            Mapping mapping = (Mapping)m;
            Field inputField = (Field)mapping.getInputField().get(0);
            boolean inputIsCollection = PathUtil.isCollection(inputField.getPath());
            if (!inputIsCollection) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Internal mapping's input field is not a collection, not cloning: " + mapping);
                }
                for (Field f : mapping.getOutputField()) {
                    f.setPath(PathUtil.overwriteCollectionIndex(f.getPath(), 0));
                }
                mappings.add(mapping);
                continue;
            }
            int inputCollectionSize = this.getCollectionSize(session, inputField);
            if (logger.isDebugEnabled()) {
                logger.debug("Internal mapping's input field is a collection. Cloning it for each item (" + inputCollectionSize + " clones): " + mapping);
            }
            for (int i = 0; i < inputCollectionSize; ++i) {
                Field clonedField;
                Mapping cloneMapping = (Mapping)AtlasModelFactory.cloneMapping((BaseMapping)mapping, (boolean)false);
                for (Field f : mapping.getInputField()) {
                    clonedField = this.cloneField(f);
                    clonedField.setPath(PathUtil.overwriteCollectionIndex(clonedField.getPath(), i));
                    cloneMapping.getInputField().add(clonedField);
                }
                for (Field f : mapping.getOutputField()) {
                    clonedField = this.cloneField(f);
                    if (PathUtil.isCollection(clonedField.getPath())) {
                        clonedField.setPath(PathUtil.overwriteCollectionIndex(clonedField.getPath(), i));
                    }
                    cloneMapping.getOutputField().add(clonedField);
                }
                mappings.add(cloneMapping);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Generated " + mappings.size() + " mappings from mapping: " + baseMapping);
        }
        ((Collection)baseMapping).getMappings().getMapping().clear();
        ((Collection)baseMapping).getMappings().getMapping().addAll(mappings);
        return mappings;
    }

    public List<Mapping> getOutputMappings(AtlasSession session, BaseMapping baseMapping) throws AtlasException {
        if (!baseMapping.getMappingType().equals((Object)MappingType.COLLECTION)) {
            return Arrays.asList((Mapping)baseMapping);
        }
        LinkedList<Mapping> mappings = new LinkedList<Mapping>();
        for (BaseMapping m : ((Collection)baseMapping).getMappings().getMapping()) {
            mappings.add((Mapping)m);
        }
        return mappings;
    }

    public void processPreInputExecution(AtlasSession session) throws AtlasException {
        if (logger.isDebugEnabled()) {
            logger.debug("processPreInputExcution completed");
        }
    }

    public void processPostInputExecution(AtlasSession session) throws AtlasException {
        if (logger.isDebugEnabled()) {
            logger.debug("processPostInputExecution completed");
        }
    }

    public void processPostValidation(AtlasSession session) throws AtlasException {
        if (logger.isDebugEnabled()) {
            logger.debug("processPostValidation completed");
        }
    }

    protected void processConstantField(AtlasSession atlasSession, Mapping mapping) throws AtlasException {
        for (Field f : mapping.getInputField()) {
            if (!(f instanceof ConstantField) || f.getFieldType() != null || f.getValue() == null) continue;
            f.setFieldType(this.getConversionService().fieldTypeFromClass(f.getValue().getClass()));
        }
    }

    protected void processPropertyField(AtlasSession atlasSession, Mapping mapping, AtlasPropertyStrategy atlasPropertyStrategy) throws AtlasException {
        for (Field f : mapping.getInputField()) {
            if (!(f instanceof PropertyField)) continue;
            atlasPropertyStrategy.processPropertyField(atlasSession.getMapping(), (PropertyField)f, atlasSession.getProperties());
        }
        for (Field f : mapping.getOutputField()) {
            if (!(f instanceof PropertyField)) continue;
            atlasPropertyStrategy.processPropertyField(atlasSession.getMapping(), (PropertyField)f, atlasSession.getProperties());
        }
    }

    protected void processLookupField(AtlasSession session, Mapping mapping) throws AtlasException {
        if (mapping == null || mapping.getMappingType() == null || MappingType.LOOKUP.equals((Object)mapping.getMappingType()) || mapping.getLookupTableName() == null || mapping.getLookupTableName().trim().length() == 0) {
            throw new AtlasException("Lookup mapping must have lookupTableName specified");
        }
        if (session == null || session.getMapping() == null) {
            throw new AtlasException("AtlasSession must be initialized");
        }
        if (session.getMapping().getLookupTables() == null || session.getMapping().getLookupTables().getLookupTable() == null || session.getMapping().getLookupTables().getLookupTable().size() == 0) {
            logger.warn(String.format("No lookup table found for specified lookupTableName=%s", mapping.getLookupTableName()));
            return;
        }
        LookupTable currentTable = null;
        for (LookupTable lookupTable : session.getMapping().getLookupTables().getLookupTable()) {
            if (lookupTable.getName() == null || !lookupTable.getName().equals(mapping.getLookupTableName())) continue;
            currentTable = lookupTable;
        }
        if (currentTable.getLookupEntry() == null || currentTable.getLookupEntry().isEmpty()) {
            logger.warn(String.format("Lookup table lookupTableName=%s does not contain any entries", mapping.getLookupTableName()));
            return;
        }
        for (LookupEntry entry : currentTable.getLookupEntry()) {
            for (Field inputField : mapping.getInputField()) {
                if (!entry.getSourceValue().equals(inputField.getValue())) continue;
                inputField.setValue((Object)entry.getTargetValue());
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Processing lookup value for iP=%s iV=%s lksV=%s lksT=%s lktV=%s lktT=%s", inputField.getPath(), inputField.getValue(), entry.getSourceValue(), entry.getSourceType(), entry.getTargetValue(), entry.getTargetType()));
            }
        }
    }

    protected Field processSeparateField(AtlasSession session, Mapping mapping, Field inputField, Field outputField) throws AtlasException {
        if (outputField.getIndex() == null || outputField.getIndex() < 0) {
            logger.warn(String.format("Separate requires zero or positive Index value to be set on outputField outputField.path=%s", outputField.getPath()));
            this.addAudit(session, outputField.getDocId(), String.format("Separate requires zero or positive Index value to be set on outputField outputField.path=%s", outputField.getPath()), outputField.getPath(), AuditStatus.ERROR, null);
            return null;
        }
        Field inputFieldsep = (Field)mapping.getInputField().get(0);
        if (inputFieldsep.getFieldType() != null && !FieldType.STRING.equals((Object)inputFieldsep.getFieldType()) || inputFieldsep.getValue() == null || !inputFieldsep.getValue().getClass().isAssignableFrom(String.class)) {
            logger.warn(String.format("Separate requires String field type for inputField.path=%s", inputFieldsep.getPath()));
            this.addAudit(session, outputField.getDocId(), String.format("Separate requires String field type for inputField.path=%s", inputFieldsep.getPath()), outputField.getPath(), AuditStatus.WARN, null);
            return null;
        }
        String inputValue = (String)inputFieldsep.getValue();
        List separatedValues = null;
        separatedValues = mapping.getDelimiter() != null ? session.getAtlasContext().getContextFactory().getSeparateStrategy().separateValue(inputValue, mapping.getDelimiter()) : session.getAtlasContext().getContextFactory().getSeparateStrategy().separateValue(inputValue);
        if (separatedValues == null || separatedValues.isEmpty()) {
            logger.debug(String.format("Empty string for Separate mapping inputField.path=%s", inputFieldsep.getPath()));
            return null;
        }
        if (separatedValues.size() <= outputField.getIndex()) {
            logger.error(String.format("Separate returned fewer segements count=%s when outputField.path=%s requested index=%s", separatedValues.size(), outputField.getPath(), outputField.getIndex()));
            this.addAudit(session, outputField.getDocId(), String.format("Separate returned fewer segements count=%s when outputField.path=%s requested index=%s", separatedValues.size(), outputField.getPath(), outputField.getIndex()), outputField.getPath(), AuditStatus.ERROR, null);
            return null;
        }
        SimpleField simpleField = AtlasModelFactory.cloneFieldToSimpleField((Field)inputFieldsep);
        simpleField.setValue(separatedValues.get(outputField.getIndex()));
        return simpleField;
    }

    protected void processCombineField(AtlasSession session, Mapping mapping, List<Field> inputFields, Field outputField) throws AtlasException {
        HashMap<Integer, String> combineValues = null;
        for (Field inputField : inputFields) {
            if (inputField.getIndex() == null || inputField.getIndex() < 0) {
                logger.error(String.format("Combine requires zero or positive Index value to be set on all inputFields inputField.path=%s", inputField.getPath()));
                this.addAudit(session, outputField.getDocId(), String.format("Combine requires zero or positive Index value to be set on all inputFields inputField.path=%s", inputField.getPath()), outputField.getPath(), AuditStatus.ERROR, null);
                continue;
            }
            if (inputField.getFieldType() != null && !FieldType.STRING.equals((Object)inputField.getFieldType()) || inputField.getValue() != null && !inputField.getValue().getClass().isAssignableFrom(String.class)) {
                logger.error(String.format("Combine requires String field type for inputField.path=%s", inputField.getPath()));
                this.addAudit(session, outputField.getDocId(), String.format("Combine requires String field type for inputField.path=%s", inputField.getPath()), outputField.getPath(), AuditStatus.WARN, null);
                continue;
            }
            if (combineValues == null) {
                combineValues = new HashMap<Integer, String>();
            }
            combineValues.put(inputField.getIndex(), (String)inputField.getValue());
        }
        String combinedValue = null;
        combinedValue = mapping.getDelimiter() != null ? session.getAtlasContext().getContextFactory().getCombineStrategy().combineValues(combineValues, mapping.getDelimiter()) : session.getAtlasContext().getContextFactory().getCombineStrategy().combineValues(combineValues);
        if (combinedValue == null || combinedValue.trim().isEmpty()) {
            logger.debug(String.format("Empty combined string for Combine mapping outputField.path=%s", outputField.getPath()));
            return;
        }
        outputField.setValue((Object)combinedValue);
    }

    protected void processLookupField(AtlasSession session, String lookupTableName, String inputValue, Field outputField) throws AtlasException {
        LookupTable table = null;
        for (LookupTable t : session.getMapping().getLookupTables().getLookupTable()) {
            if (!t.getName().equals(lookupTableName)) continue;
            table = t;
            break;
        }
        if (table == null) {
            throw new AtlasException("Could not find lookup table with name '" + lookupTableName + "' for outputField: " + outputField.getPath());
        }
        String lookupValue = null;
        FieldType lookupType = null;
        for (LookupEntry lkp : table.getLookupEntry()) {
            if (!lkp.getSourceValue().equals(inputValue)) continue;
            lookupValue = lkp.getTargetValue();
            lookupType = lkp.getTargetType();
            break;
        }
        Object outputValue = null;
        outputValue = lookupType == null || FieldType.STRING.equals(lookupType) ? lookupValue : this.getConversionService().convertType((Object)lookupValue, FieldType.STRING, lookupType);
        if (outputField.getFieldType() != null && !outputField.getFieldType().equals(lookupType)) {
            outputValue = this.getConversionService().convertType(outputValue, lookupType, outputField.getFieldType());
        }
        outputField.setValue(outputValue);
    }

    protected void addAudit(AtlasSession session, String docId, String message, String path, AuditStatus status, String value) {
        Audit audit = new Audit();
        audit.setDocId(docId);
        audit.setMessage(message);
        audit.setPath(path);
        audit.setStatus(status);
        audit.setValue(value);
        session.getAudits().getAudit().add(audit);
    }

    protected void processFieldActions(AtlasFieldActionService fieldActionService, Field field) throws AtlasException {
        field.setValue(fieldActionService.processActions(field.getActions(), field.getValue(), field.getFieldType()));
    }

    public AtlasModuleMode getMode() {
        return this.atlasModuleMode;
    }

    public void setMode(AtlasModuleMode atlasModuleMode) {
        this.atlasModuleMode = atlasModuleMode;
    }

    public Boolean isStatisticsSupported() {
        return false;
    }

    public Boolean isStatisticsEnabled() {
        return false;
    }

    public List<AtlasModuleMode> listSupportedModes() {
        return Arrays.asList(AtlasModuleMode.SOURCE, AtlasModuleMode.TARGET);
    }

    public AtlasConversionService getConversionService() {
        return this.atlasConversionService;
    }

    public void setConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }
}

