/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasConverter;
import io.atlasmap.api.AtlasValidationService;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class BaseModuleValidationService<T extends Field>
implements AtlasValidationService {
    private AtlasConversionService conversionService;
    private AtlasModuleMode mode;

    public BaseModuleValidationService() {
        this.conversionService = DefaultAtlasConversionService.getInstance();
    }

    public BaseModuleValidationService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setMode(AtlasModuleMode mode) {
        this.mode = mode;
    }

    public AtlasModuleMode getMode() {
        return this.mode;
    }

    protected abstract AtlasModuleDetail getModuleDetail();

    public List<Validation> validateMapping(AtlasMapping mapping) {
        ArrayList<Validation> validations = new ArrayList<Validation>();
        if (this.getMode() == AtlasModuleMode.UNSET) {
            Validation validation = new Validation();
            validation.setMessage(String.format("No mode specified for %s/%s, skipping module validations", this.getModuleDetail().name(), this.getClass().getSimpleName()));
        }
        if (mapping != null && mapping.getMappings() != null && mapping.getMappings().getMapping() != null && !mapping.getMappings().getMapping().isEmpty()) {
            this.validateMappingEntries(mapping.getMappings().getMapping(), validations);
        }
        boolean found = false;
        for (DataSource ds : mapping.getDataSource()) {
            if (ds.getUri() == null || !ds.getUri().startsWith(this.getModuleDetail().uri())) continue;
            found = true;
        }
        if (!found) {
            Validation validation = new Validation();
            validation.setField(String.format("DataSource.uri", new Object[0]));
            validation.setMessage(String.format("No DataSource with '%s' uri specified", this.getModuleDetail().uri()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        }
        return validations;
    }

    protected void validateMappingEntries(List<BaseMapping> mappings, List<Validation> validations) {
        for (BaseMapping fieldMapping : mappings) {
            if (fieldMapping.getClass().isAssignableFrom(Mapping.class) && MappingType.MAP.equals((Object)((Mapping)fieldMapping).getMappingType())) {
                this.validateMapMapping((Mapping)fieldMapping, validations);
                continue;
            }
            if (!fieldMapping.getClass().isAssignableFrom(Mapping.class) || !MappingType.SEPARATE.equals((Object)((Mapping)fieldMapping).getMappingType())) continue;
            this.validateSeparateMapping((Mapping)fieldMapping, validations);
        }
    }

    protected void validateMapMapping(Mapping mapping, List<Validation> validations) {
        Field inputField = null;
        Field outField = null;
        if (mapping != null && mapping.getInputField() != null && mapping.getInputField().size() > 0) {
            inputField = (Field)mapping.getInputField().get(0);
            if (this.getMode() == AtlasModuleMode.SOURCE) {
                this.validateField(inputField, FieldDirection.INPUT, validations);
            }
        }
        if (mapping != null && mapping.getOutputField() != null && mapping.getOutputField().size() > 0) {
            outField = (Field)mapping.getOutputField().get(0);
            if (this.getMode() == AtlasModuleMode.TARGET) {
                this.validateField(outField, FieldDirection.OUTPUT, validations);
            }
        }
        if (inputField != null && outField != null && this.getMode() == AtlasModuleMode.SOURCE) {
            this.validateSourceAndTargetTypes(inputField, outField, validations);
        }
    }

    protected void validateSeparateMapping(Mapping mapping, List<Validation> validations) {
        if (mapping == null) {
            return;
        }
        Field inputField = mapping.getInputField() != null ? (Field)mapping.getInputField().get(0) : null;
        List outputFields = mapping.getOutputField();
        if (this.getMode() == AtlasModuleMode.SOURCE) {
            if (inputField.getFieldType() != FieldType.STRING) {
                Validation validation = new Validation();
                validation.setField("Input.Field");
                validation.setMessage("Input field must be of type " + FieldType.STRING + " for a Separate Mapping");
                validation.setStatus(ValidationStatus.ERROR);
                validation.setValue(this.getFieldName(inputField));
                validations.add(validation);
            }
            this.validateField(inputField, FieldDirection.INPUT, validations);
            if (outputFields != null) {
                for (Field outField2 : outputFields) {
                    this.validateSourceAndTargetTypes(inputField, outField2, validations);
                }
            }
        } else if (outputFields != null) {
            outputFields.forEach(outField -> this.validateField((Field)outField, FieldDirection.OUTPUT, validations));
        }
    }

    protected void validateField(Field field, FieldDirection direction, List<Validation> validations) {
        if (field == null || !this.getFieldType().isAssignableFrom(field.getClass())) {
            Validation validation = new Validation();
            validation.setField(String.format("%s.Field", direction.value()));
            validation.setMessage(String.format("%s field %s is not supported by the %s", direction.value(), this.getFieldName(field), this.getModuleDetail().name()));
            validation.setStatus(ValidationStatus.ERROR);
            validations.add(validation);
        } else {
            this.validateModuleField(field, direction, validations);
        }
    }

    protected abstract Class<T> getFieldType();

    protected abstract void validateModuleField(T var1, FieldDirection var2, List<Validation> var3);

    protected void validateSourceAndTargetTypes(Field inputField, Field outField, List<Validation> validations) {
        if (inputField.getFieldType() != outField.getFieldType()) {
            this.validateFieldTypeConversion(inputField, outField, validations);
        }
    }

    protected void populateConversionConcerns(AtlasConversionConcern[] atlasConversionConcerns, String value, List<Validation> validations) {
        if (atlasConversionConcerns == null) {
            return;
        }
        for (AtlasConversionConcern atlasConversionConcern : atlasConversionConcerns) {
            Validation validation;
            if (AtlasConversionConcern.NONE.equals((Object)atlasConversionConcern)) {
                validation = new Validation();
                validation.setField("Field.Input/Output.conversion");
                validation.setMessage(atlasConversionConcern.getMessage());
                validation.setStatus(ValidationStatus.INFO);
                validation.setValue(value);
                validations.add(validation);
            }
            if (atlasConversionConcern.equals((Object)AtlasConversionConcern.RANGE) || atlasConversionConcern.equals((Object)AtlasConversionConcern.FORMAT)) {
                validation = new Validation();
                validation.setField("Field.Input/Output.conversion");
                validation.setMessage(atlasConversionConcern.getMessage());
                validation.setStatus(ValidationStatus.WARN);
                validation.setValue(value);
                validations.add(validation);
            }
            if (!atlasConversionConcern.equals((Object)AtlasConversionConcern.UNSUPPORTED)) continue;
            validation = new Validation();
            validation.setField("Field.Input/Output.conversion");
            validation.setMessage(atlasConversionConcern.getMessage());
            validation.setStatus(ValidationStatus.ERROR);
            validation.setValue(value);
            validations.add(validation);
        }
    }

    protected void validateFieldTypeConversion(Field inputField, Field outField, List<Validation> validations) {
        FieldType inFieldType = inputField.getFieldType();
        FieldType outFieldType = outField.getFieldType();
        Optional atlasConverter = this.conversionService.findMatchingConverter(inFieldType, outFieldType);
        String rejectedValue = this.getFieldName(inputField) + " --> " + this.getFieldName(outField);
        if (!atlasConverter.isPresent()) {
            Validation validation = new Validation();
            validation.setField("Field.Input/Output.conversion");
            validation.setMessage("A conversion between the input and output fields is required but no converter is available");
            validation.setStatus(ValidationStatus.WARN);
            validation.setValue(rejectedValue);
            validations.add(validation);
        } else {
            Method[] methods = ((AtlasConverter)atlasConverter.get()).getClass().getMethods();
            AtlasConversionInfo conversionInfo = Arrays.stream(methods).map(method -> method.getAnnotation(AtlasConversionInfo.class)).filter(atlasConversionInfo -> atlasConversionInfo != null).filter(atlasConversionInfo -> atlasConversionInfo.sourceType().compareTo((Enum)inFieldType) == 0 && atlasConversionInfo.targetType().compareTo((Enum)outFieldType) == 0).findFirst().orElse(null);
            if (conversionInfo != null) {
                this.populateConversionConcerns(conversionInfo.concerns(), rejectedValue, validations);
            }
        }
    }

    protected String getFieldName(Field field) {
        if (field == null) {
            return "null";
        }
        if (field.getClass().isAssignableFrom(this.getFieldType())) {
            return this.getModuleFieldName(field);
        }
        if (field.getFieldType() != null) {
            return field.getFieldType().name();
        }
        return field.getClass().getName();
    }

    protected abstract String getModuleFieldName(T var1);

    protected AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    protected void setConversionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public static enum FieldDirection {
        INPUT("Input"),
        OUTPUT("Output");

        private String value;

        private FieldDirection(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

