/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasMappingService;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.mxbean.AtlasContextMXBean;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.AtlasModuleInfo;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Validations;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasContext
implements AtlasContext,
AtlasContextMXBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAtlasContext.class);
    private ObjectName jmxObjectName;
    private final UUID uuid;
    private DefaultAtlasContextFactory factory;
    private AtlasMapping mappingDefinition;
    private AtlasMappingService.AtlasMappingFormat atlasMappingFormat;
    private URI atlasMappingUri;
    private AtlasModule sourceModule;
    private AtlasModule targetModule;
    private Class<AtlasModule> sourceModuleClass;
    private Class<AtlasModule> targetModuleClass;
    private String sourceFormat;
    private String targetFormat;
    private Map<String, String> sourceProperties;
    private Map<String, String> targetProperties;

    public DefaultAtlasContext(URI atlasMappingUri) throws AtlasException {
        this.factory = DefaultAtlasContextFactory.getInstance();
        this.uuid = UUID.randomUUID();
        this.atlasMappingUri = atlasMappingUri;
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, URI atlasMappingUri) throws AtlasException {
        this(factory, atlasMappingUri, AtlasMappingService.AtlasMappingFormat.XML);
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, URI atlasMappingUri, AtlasMappingService.AtlasMappingFormat format) throws AtlasException {
        this.factory = factory;
        this.uuid = UUID.randomUUID();
        this.atlasMappingUri = atlasMappingUri;
        this.atlasMappingFormat = format;
    }

    public DefaultAtlasContext(DefaultAtlasContextFactory factory, AtlasMapping mapping) throws AtlasException {
        this.factory = factory;
        this.uuid = UUID.randomUUID();
        this.mappingDefinition = mapping;
    }

    protected void init() throws AtlasException {
        this.registerJmx(this);
        if (this.atlasMappingUri != null) {
            this.mappingDefinition = this.factory.getMappingService().loadMapping(this.atlasMappingUri, this.atlasMappingFormat);
        }
        List<AtlasModuleInfo> modules = this.factory.getModules();
        for (AtlasModuleInfo module : modules) {
            if (AtlasUtil.matchUriModule(module.getUri(), this.getSourceModuleUri())) {
                try {
                    this.setSourceModuleClass(Class.forName(module.getModuleClassName()));
                    this.setSourceModule(this.getSourceModuleClass().newInstance());
                    this.getSourceModule().setMode(AtlasModuleMode.SOURCE);
                    this.getSourceModule().setConversionService(this.getDefaultAtlasContextFactory().getConversionService());
                    this.getSourceModule().init();
                }
                catch (ClassNotFoundException e) {
                    logger.error("Cannot find source ModuleClass " + module.toString(), (Throwable)e);
                    throw new AtlasException("Cannot source ModuleClass: " + module.getModuleClassName(), (Throwable)e);
                }
                catch (ReflectiveOperationException e) {
                    logger.error("Unable to initialize target module: " + module.toString(), (Throwable)e);
                    throw new AtlasException("Unable to initialize target module: " + module.getModuleClassName(), (Throwable)e);
                }
            }
            if (!AtlasUtil.matchUriModule(module.getUri(), this.getTargetModuleUri())) continue;
            try {
                this.setTargetModuleClass(Class.forName(module.getModuleClassName()));
                this.setTargetModule(this.getTargetModuleClass().newInstance());
                this.getTargetModule().setMode(AtlasModuleMode.TARGET);
                this.getTargetModule().setConversionService(this.getDefaultAtlasContextFactory().getConversionService());
                this.getTargetModule().init();
            }
            catch (ClassNotFoundException e) {
                logger.error("Cannot find target ModuleClass: " + module.toString(), (Throwable)e);
                throw new AtlasException("Cannot find target ModuleClass: " + module.getModuleClassName(), (Throwable)e);
            }
            catch (ReflectiveOperationException e) {
                logger.error("Unable to initialize target module: " + module.toString(), (Throwable)e);
                throw new AtlasException("Unable to initialize target module: " + module.getModuleClassName(), (Throwable)e);
            }
        }
    }

    protected void registerJmx(DefaultAtlasContext context) {
        try {
            this.setJmxObjectName(new ObjectName(this.getDefaultAtlasContextFactory().getJmxObjectName() + ",context=Contexts,uuid=" + this.uuid.toString()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.getJmxObjectName());
            if (logger.isDebugEnabled()) {
                logger.debug("Registered AtlasContext " + context.getUuid() + " with JMX");
            }
        }
        catch (Throwable t) {
            logger.warn("Failured to register AtlasContext " + context.getUuid() + " with JMX msg: " + t.getMessage(), t);
        }
    }

    public void process(AtlasSession session) throws AtlasException {
        if (logger.isDebugEnabled()) {
            logger.debug("Begin process " + (session == null ? null : session.toString()));
        }
        this.getSourceModule().processPreValidation(session);
        this.getTargetModule().processPreValidation(session);
        this.getSourceModule().processPreInputExecution(session);
        this.getTargetModule().processPreOutputExecution(session);
        for (BaseMapping mapping : session.getMapping().getMappings().getMapping()) {
            this.getSourceModule().processInputMapping(session, mapping);
            this.getSourceModule().processInputActions(session, mapping);
            this.getTargetModule().processOutputMapping(session, mapping);
            if (!session.hasErrors()) continue;
            logger.error(String.format("Aborting processing due to %s errors", session.errorCount()));
            break;
        }
        this.getSourceModule().processPostValidation(session);
        this.getTargetModule().processPostValidation(session);
        this.getSourceModule().processPostInputExecution(session);
        this.getTargetModule().processPostOutputExecution(session);
        if (logger.isDebugEnabled()) {
            logger.debug("End process " + (session == null ? null : session.toString()));
        }
    }

    public void processValidation(AtlasSession session) throws AtlasException {
        List validations;
        if (logger.isDebugEnabled()) {
            logger.debug("Begin processValidation " + (session == null ? null : session.toString()));
        }
        if ((validations = this.getContextFactory().getValidationService().validateMapping(session.getMapping())) != null && !validations.isEmpty()) {
            session.getValidations().getValidation().addAll(validations);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Detected " + validations.size() + " core validation notices");
        }
        if (this.getSourceModule() != null) {
            this.getSourceModule().processPreValidation(session);
        }
        if (this.getTargetModule() != null) {
            this.getTargetModule().processPreValidation(session);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("End processValidation " + (session == null ? null : session.toString()));
        }
    }

    protected DefaultAtlasContextFactory getDefaultAtlasContextFactory() {
        return this.factory;
    }

    public AtlasContextFactory getContextFactory() {
        return this.factory;
    }

    public AtlasMapping getMapping() {
        return this.mappingDefinition;
    }

    public AtlasSession createSession() throws AtlasValidationException {
        if (this.atlasMappingUri != null) {
            return this.createSession(this.getDefaultAtlasContextFactory().getMappingService().loadMapping(this.atlasMappingUri, this.atlasMappingFormat));
        }
        return this.createSession(this.mappingDefinition);
    }

    public AtlasSession createSession(AtlasMapping mappingDefinition) {
        DefaultAtlasSession session = new DefaultAtlasSession(mappingDefinition);
        session.setAtlasContext(this);
        session.setAudits(new Audits());
        session.setValidations(new Validations());
        this.setDefaultSessionProperties(session);
        return session;
    }

    protected void setDefaultSessionProperties(AtlasSession session) {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        df.setTimeZone(TimeZone.getDefault());
        session.getProperties().put("Atlas.CreatedDateTimeTZ", df.format(date));
    }

    public AtlasModule getSourceModule() {
        return this.sourceModule;
    }

    public void setSourceModule(AtlasModule sourceModule) {
        this.sourceModule = sourceModule;
    }

    public AtlasModule getTargetModule() {
        return this.targetModule;
    }

    public void setTargetModule(AtlasModule targetModule) {
        this.targetModule = targetModule;
    }

    public Class<AtlasModule> getSourceModuleClass() {
        return this.sourceModuleClass;
    }

    public void setSourceModuleClass(Class<AtlasModule> sourceModuleClass) {
        this.sourceModuleClass = sourceModuleClass;
    }

    public Class<AtlasModule> getTargetModuleClass() {
        return this.targetModuleClass;
    }

    public void setTargetModuleClass(Class<AtlasModule> targetModuleClass) {
        this.targetModuleClass = targetModuleClass;
    }

    public String getSourceFormat() {
        return this.sourceFormat;
    }

    public void setSourceFormat(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public String getTargetFormat() {
        return this.targetFormat;
    }

    public void setTargetFormat(String targetFormat) {
        this.targetFormat = targetFormat;
    }

    public Map<String, String> getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(Map<String, String> sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public Map<String, String> getTargetProperties() {
        return this.targetProperties;
    }

    public void setTargetProperties(Map<String, String> targetProperties) {
        this.targetProperties = targetProperties;
    }

    protected void setJmxObjectName(ObjectName jmxObjectName) {
        this.jmxObjectName = jmxObjectName;
    }

    public ObjectName getJmxObjectName() {
        return this.jmxObjectName;
    }

    public String getSourceModuleUri() {
        return this.doGetModuleUri(DataSourceType.SOURCE);
    }

    public String getTargetModuleUri() {
        return this.doGetModuleUri(DataSourceType.TARGET);
    }

    private String doGetModuleUri(DataSourceType type) {
        DataSource sourceds = null;
        if (this.getMapping() != null && this.getMapping().getDataSource() != null) {
            for (DataSource ds : this.getMapping().getDataSource()) {
                if (ds.getDataSourceType() != type) continue;
                if (sourceds == null) {
                    sourceds = ds;
                    continue;
                }
                logger.warn("Multiple {} DataSource found, ignoring '{}'", (Object)type, (Object)ds.getId());
            }
        }
        return sourceds != null ? sourceds.getUri() : null;
    }

    public String getUuid() {
        return this.uuid != null ? this.uuid.toString() : null;
    }

    public String getVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public String getMappingName() {
        return this.mappingDefinition != null ? this.mappingDefinition.getName() : null;
    }

    protected void setMappingUri(URI atlasMappingUri) {
        this.atlasMappingUri = atlasMappingUri;
    }

    public String getMappingUri() {
        return this.atlasMappingUri != null ? this.atlasMappingUri.toString() : null;
    }

    public String getClassName() {
        return this.getClass().getSimpleName();
    }

    public String getThreadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        return "DefaultAtlasContext [jmxObjectName=" + this.jmxObjectName + ", uuid=" + this.uuid + ", factory=" + this.factory + ", mappingName=" + this.getMappingName() + ", mappingUri=" + this.getMappingUri() + ", sourceModule=" + this.sourceModule + ", targetModule=" + this.targetModule + ", sourceModuleClass=" + this.sourceModuleClass + ", targetModuleClass=" + this.targetModuleClass + ", sourceFormat=" + this.sourceFormat + ", targetFormat=" + this.targetFormat + ", sourceProperties=" + this.sourceProperties + ", targetProperties=" + this.targetProperties + "]";
    }
}

