/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasConverter;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasConversionService
implements AtlasConversionService {
    private static Logger logger = LoggerFactory.getLogger(DefaultAtlasConversionService.class);
    private static DefaultAtlasConversionService instance = null;
    private Map<String, AtlasConverter<?>> converters = null;
    private static final Set<String> PRIMITIVE_CLASSNAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short")));
    private static final Set<String> BOXED_PRIMITIVE_CLASSNAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String")));

    private DefaultAtlasConversionService() {
    }

    public static DefaultAtlasConversionService getInstance() {
        if (instance == null) {
            instance = new DefaultAtlasConversionService();
            instance.init();
        }
        return instance;
    }

    public static Set<String> listPrimitiveClassNames() {
        return PRIMITIVE_CLASSNAMES;
    }

    public Optional<AtlasConverter> findMatchingConverter(FieldType source, FieldType target) {
        Optional<Object> primitiveConverter = Optional.empty();
        Optional<Object> customConverter = Optional.empty();
        List<AtlasPrimitiveConverter> primitiveConverters = this.converters.values().stream().filter(p -> p instanceof AtlasPrimitiveConverter).map(p -> (AtlasPrimitiveConverter)p).collect(Collectors.toList());
        primitiveConverter = this.checkPrimitiveConverters(primitiveConverters, source, target);
        List<AtlasConverter> customConverters = this.converters.values().stream().filter(DefaultAtlasConversionService.not(p -> p instanceof AtlasPrimitiveConverter)).collect(Collectors.toList());
        customConverter = this.checkCustomConverters(customConverters, source, target);
        if (primitiveConverter.isPresent() && !customConverter.isPresent()) {
            return primitiveConverter;
        }
        return customConverter;
    }

    public Optional<AtlasConverter> findMatchingConverter(String sourceClassName, String targetClassName) {
        List customConverters = this.converters.values().stream().filter(DefaultAtlasConversionService.not(p -> p instanceof AtlasPrimitiveConverter)).collect(Collectors.toList());
        for (AtlasConverter converter : customConverters) {
            if (!this.findConverterByMethodAnnotationClassName(sourceClassName, targetClassName, converter)) continue;
            return Optional.of(converter);
        }
        return Optional.empty();
    }

    public Optional<Method> findMatchingMethod(FieldType source, FieldType target, AtlasConverter customConverter) {
        Method[] methods = customConverter.getClass().getMethods();
        return Arrays.stream(methods).filter(method -> method.isAnnotationPresent(AtlasConversionInfo.class) && method.getAnnotation(AtlasConversionInfo.class) != null && method.getAnnotation(AtlasConversionInfo.class).sourceType().compareTo((Enum)source) == 0 && method.getAnnotation(AtlasConversionInfo.class).targetType().compareTo((Enum)target) == 0).findFirst();
    }

    private Optional<AtlasConverter> checkCustomConverters(List<AtlasConverter> customConverters, FieldType source, FieldType target) {
        if (source == null || target == null) {
            return Optional.empty();
        }
        for (AtlasConverter customConverter : customConverters) {
            if (!this.findConverterByMethodAnnotationSourceType(source, target, customConverter)) continue;
            return Optional.of(customConverter);
        }
        return Optional.empty();
    }

    private Optional<AtlasConverter> checkPrimitiveConverters(List<AtlasPrimitiveConverter> primitiveConverters, FieldType source, FieldType target) {
        if (source == null || target == null) {
            return Optional.empty();
        }
        for (AtlasPrimitiveConverter primitiveConverter : primitiveConverters) {
            if (!this.findConverterByMethodAnnotationSourceType(source, target, (AtlasConverter<?>)primitiveConverter)) continue;
            return Optional.of(primitiveConverter);
        }
        return Optional.empty();
    }

    private boolean findConverterByMethodAnnotationSourceType(FieldType source, FieldType target, AtlasConverter<?> customConverter) {
        Method[] methods = customConverter.getClass().getMethods();
        return Arrays.stream(methods).map(method -> method.getAnnotation(AtlasConversionInfo.class)).anyMatch(atlasConversionInfo -> atlasConversionInfo != null && atlasConversionInfo.sourceType().compareTo((Enum)source) == 0 && atlasConversionInfo.targetType().compareTo((Enum)target) == 0);
    }

    private boolean findConverterByMethodAnnotationClassName(String sourceClassName, String targetClassName, AtlasConverter<?> customConverter) {
        Method[] methods = customConverter.getClass().getMethods();
        return Arrays.stream(methods).map(method -> method.getAnnotation(AtlasConversionInfo.class)).anyMatch(atlasConversionInfo -> atlasConversionInfo != null && atlasConversionInfo.sourceClassName().equals(sourceClassName) && atlasConversionInfo.targetClassName().equals(targetClassName));
    }

    private void init() {
        this.loadConverters();
    }

    private void loadConverters() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ServiceLoader<AtlasConverter> converterServiceLoader = ServiceLoader.load(AtlasConverter.class, classLoader);
        LinkedHashMap<String, AtlasConverter> tmp = new LinkedHashMap<String, AtlasConverter>();
        for (AtlasConverter atlasConverter : converterServiceLoader) {
            if (logger.isDebugEnabled()) {
                logger.debug("Loading converter : " + atlasConverter.getClass().getCanonicalName());
            }
            tmp.put(atlasConverter.getClass().getCanonicalName(), atlasConverter);
        }
        if (!tmp.isEmpty()) {
            this.converters = Collections.unmodifiableMap(tmp);
        }
    }

    private static <R> Predicate<R> not(Predicate<R> predicate) {
        return predicate.negate();
    }

    public Object copyPrimitive(Object sourceValue) {
        if (sourceValue == null) {
            return null;
        }
        Class<?> clazz = sourceValue.getClass();
        if (clazz == null) {
            return clazz;
        }
        if (Boolean.TYPE.getName().equals(clazz.getName())) {
            return (boolean)((Boolean)sourceValue);
        }
        if (Boolean.class.getName().equals(clazz.getName())) {
            return (boolean)((Boolean)sourceValue);
        }
        if (Byte.TYPE.getName().equals(clazz.getName())) {
            return (byte)((Byte)sourceValue);
        }
        if (Byte.class.getName().equals(clazz.getName())) {
            return (byte)((Byte)sourceValue);
        }
        if (Character.TYPE.getName().equals(clazz.getName())) {
            return Character.valueOf(((Character)sourceValue).charValue());
        }
        if (Character.class.getName().equals(clazz.getName())) {
            return Character.valueOf(((Character)sourceValue).charValue());
        }
        if (Double.TYPE.getName().equals(clazz.getName())) {
            return (double)((Double)sourceValue);
        }
        if (Double.class.getName().equals(clazz.getName())) {
            return (double)((Double)sourceValue);
        }
        if (Float.TYPE.getName().equals(clazz.getName())) {
            return Float.valueOf(((Float)sourceValue).floatValue());
        }
        if (Float.class.getName().equals(clazz.getName())) {
            return Float.valueOf(((Float)sourceValue).floatValue());
        }
        if (Integer.TYPE.getName().equals(clazz.getName())) {
            return (int)((Integer)sourceValue);
        }
        if (Integer.class.getName().equals(clazz.getName())) {
            return (int)((Integer)sourceValue);
        }
        if (Long.TYPE.getName().equals(clazz.getName())) {
            return (long)((Long)sourceValue);
        }
        if (Long.class.getName().equals(clazz.getName())) {
            return (long)((Long)sourceValue);
        }
        if (Short.TYPE.getName().equals(clazz.getName())) {
            return (short)((Short)sourceValue);
        }
        if (Short.class.getName().equals(clazz.getName())) {
            return (short)((Short)sourceValue);
        }
        return sourceValue;
    }

    public Object convertType(Object sourceValue, FieldType sourceType, FieldType targetType, String customClassName) throws AtlasConversionException {
        return null;
    }

    public Object convertType(Object sourceValue, FieldType origSourceType, FieldType targetType) throws AtlasConversionException {
        FieldType sourceType = null;
        sourceType = origSourceType == null && sourceValue != null ? this.fieldTypeFromClass(sourceValue.getClass()) : FieldType.fromValue((String)origSourceType.value());
        if (sourceType == null && targetType == null) {
            throw new AtlasConversionException("AutoConversion requires sourceType and targetType be specified");
        }
        if (sourceType.equals((Object)targetType)) {
            return sourceValue;
        }
        Optional<AtlasConverter> converter = this.findMatchingConverter(sourceType, targetType);
        if (!converter.isPresent()) {
            throw new AtlasConversionException("Converter not found for sourceType: " + sourceType + " targetType: " + targetType);
        }
        AtlasConverter atlasConverter = converter.get();
        if (this.isPrimitive(sourceType).booleanValue() && this.isPrimitive(targetType).booleanValue()) {
            switch (targetType) {
                case BOOLEAN: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToBoolean(sourceValue);
                }
                case BYTE: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToByte(sourceValue);
                }
                case CHAR: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToCharacter(sourceValue);
                }
                case DOUBLE: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToDouble(sourceValue);
                }
                case FLOAT: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToFloat(sourceValue);
                }
                case INTEGER: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToInteger(sourceValue);
                }
                case LONG: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToLong(sourceValue);
                }
                case SHORT: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToShort(sourceValue);
                }
                case STRING: {
                    return ((AtlasPrimitiveConverter)atlasConverter).convertToString(sourceValue);
                }
            }
            throw new AtlasConversionException("AutoConversion is not supported for sT=" + sourceType + " tT=" + targetType);
        }
        throw new AtlasConversionException("AutoConversion of non-primitives is not supported");
    }

    public Boolean isPrimitive(String className) {
        if (className == null) {
            return false;
        }
        if (PRIMITIVE_CLASSNAMES.contains(className)) {
            return true;
        }
        return false;
    }

    public Boolean isPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (PRIMITIVE_CLASSNAMES.contains(clazz.getCanonicalName())) {
            return true;
        }
        return false;
    }

    public Boolean isPrimitive(FieldType fieldType) {
        if (fieldType == null) {
            return false;
        }
        if (Arrays.asList(FieldType.BOOLEAN, FieldType.BYTE, FieldType.CHAR, FieldType.DECIMAL, FieldType.DOUBLE, FieldType.FLOAT, FieldType.INTEGER, FieldType.LONG, FieldType.SHORT, FieldType.STRING).contains(fieldType)) {
            return true;
        }
        return false;
    }

    public Boolean isBoxedPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (BOXED_PRIMITIVE_CLASSNAMES.contains(clazz.getCanonicalName())) {
            return true;
        }
        return false;
    }

    public Class<?> boxOrUnboxPrimitive(Class<?> clazz) {
        if (clazz == null) {
            return clazz;
        }
        if (Boolean.TYPE.getName().equals(clazz.getName())) {
            return Boolean.class;
        }
        if (Boolean.class.getName().equals(clazz.getName())) {
            return Boolean.TYPE;
        }
        if (Byte.TYPE.getName().equals(clazz.getName())) {
            return Byte.class;
        }
        if (Byte.class.getName().equals(clazz.getName())) {
            return Byte.TYPE;
        }
        if (Character.TYPE.getName().equals(clazz.getName())) {
            return Character.class;
        }
        if (Character.class.getName().equals(clazz.getName())) {
            return Character.TYPE;
        }
        if (Double.TYPE.getName().equals(clazz.getName())) {
            return Double.class;
        }
        if (Double.class.getName().equals(clazz.getName())) {
            return Double.TYPE;
        }
        if (Float.TYPE.getName().equals(clazz.getName())) {
            return Float.class;
        }
        if (Float.class.getName().equals(clazz.getName())) {
            return Float.TYPE;
        }
        if (Integer.TYPE.getName().equals(clazz.getName())) {
            return Integer.class;
        }
        if (Integer.class.getName().equals(clazz.getName())) {
            return Integer.TYPE;
        }
        if (Long.TYPE.getName().equals(clazz.getName())) {
            return Long.class;
        }
        if (Long.class.getName().equals(clazz.getName())) {
            return Long.TYPE;
        }
        if (Short.TYPE.getName().equals(clazz.getName())) {
            return Short.class;
        }
        if (Short.class.getName().equals(clazz.getName())) {
            return Short.TYPE;
        }
        return clazz;
    }

    public FieldType fieldTypeFromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.fieldTypeFromClass(clazz.getName());
    }

    public FieldType fieldTypeFromClass(String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        switch (className) {
            case "boolean": {
                return FieldType.BOOLEAN;
            }
            case "java.lang.Boolean": {
                return FieldType.BOOLEAN;
            }
            case "byte": {
                return FieldType.BYTE;
            }
            case "java.lang.Byte": {
                return FieldType.BYTE;
            }
            case "char": {
                return FieldType.CHAR;
            }
            case "java.lang.Character": {
                return FieldType.CHAR;
            }
            case "double": {
                return FieldType.DOUBLE;
            }
            case "java.lang.Double": {
                return FieldType.DOUBLE;
            }
            case "float": {
                return FieldType.FLOAT;
            }
            case "java.lang.Float": {
                return FieldType.FLOAT;
            }
            case "int": {
                return FieldType.INTEGER;
            }
            case "java.lang.Integer": {
                return FieldType.INTEGER;
            }
            case "long": {
                return FieldType.LONG;
            }
            case "java.lang.Long": {
                return FieldType.LONG;
            }
            case "short": {
                return FieldType.SHORT;
            }
            case "java.lang.Short": {
                return FieldType.SHORT;
            }
            case "java.lang.String": {
                return FieldType.STRING;
            }
            case "java.time.Year": 
            case "java.time.YearMonth": 
            case "java.time.MonthDay": 
            case "java.time.LocalDate": {
                return FieldType.DATE;
            }
            case "java.time.LocalTime": {
                return FieldType.TIME;
            }
            case "java.time.LocalDateTime": {
                return FieldType.DATE_TIME;
            }
            case "java.sql.Date": 
            case "java.util.Date": 
            case "java.time.ZonedDateTime": {
                return FieldType.DATE_TIME_TZ;
            }
        }
        return FieldType.COMPLEX;
    }

    public Class<?> classFromFieldType(FieldType fieldType) {
        if (fieldType == null) {
            return null;
        }
        switch (fieldType) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case CHAR: {
                return Character.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case SHORT: {
                return Short.class;
            }
            case STRING: {
                return String.class;
            }
            case DATE: {
                return LocalDate.class;
            }
            case TIME: {
                return LocalTime.class;
            }
            case DATE_TIME: {
                return LocalDateTime.class;
            }
            case DATE_TZ: 
            case TIME_TZ: 
            case DATE_TIME_TZ: {
                return ZonedDateTime.class;
            }
        }
        return Object.class;
    }
}

