/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasFieldAction;
import io.atlasmap.api.AtlasFieldActionService;
import io.atlasmap.spi.AtlasFieldActionInfo;
import io.atlasmap.v2.Action;
import io.atlasmap.v2.ActionDetail;
import io.atlasmap.v2.ActionDetails;
import io.atlasmap.v2.Actions;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasFieldActionService
implements AtlasFieldActionService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAtlasFieldActionService.class);
    private ActionDetails actionDetails = new ActionDetails();
    private AtlasConversionService conversionService = null;

    public DefaultAtlasFieldActionService(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void init() {
        this.loadFieldActions();
    }

    protected void loadFieldActions() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ServiceLoader<AtlasFieldAction> fieldActionServiceLoader = ServiceLoader.load(AtlasFieldAction.class, classLoader);
        for (AtlasFieldAction atlasFieldAction : fieldActionServiceLoader) {
            Method[] methods;
            if (logger.isDebugEnabled()) {
                logger.debug("Loading FieldAction class: " + atlasFieldAction.getClass().getCanonicalName());
            }
            Class<?> clazz = atlasFieldAction.getClass();
            for (Method method : methods = clazz.getMethods()) {
                AtlasFieldActionInfo annotation = method.getAnnotation(AtlasFieldActionInfo.class);
                if (annotation == null) continue;
                ActionDetail det = new ActionDetail();
                det.setClassName(clazz.getName());
                det.setMethod(method.getName());
                det.setName(annotation.name());
                det.setSourceType(annotation.sourceType());
                det.setTargetType(annotation.targetType());
                det.setSourceCollectionType(annotation.sourceCollectionType());
                det.setTargetCollectionType(annotation.targetCollectionType());
                try {
                    det.setParameters(this.detectFieldActionParameters("io.atlasmap.v2." + annotation.name()));
                }
                catch (ClassNotFoundException e) {
                    logger.error(String.format("Error detecting parameters for field action=%s msg=%s", annotation.name(), e.getMessage()), (Throwable)e);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Loaded FieldAction: " + det.getName());
                }
                this.listActionDetails().add(det);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loaded %s Field Actions", this.listActionDetails().size()));
        }
    }

    public List<ActionDetail> listActionDetails() {
        return this.actionDetails.getActionDetail();
    }

    protected ActionDetail getActionDetailByActionName(String actionName) {
        for (ActionDetail actionDetail : this.listActionDetails()) {
            if (!actionDetail.getName().equals(actionName)) continue;
            return actionDetail;
        }
        return null;
    }

    public Object processActions(Actions actions, Object sourceObject, FieldType targetType) throws AtlasException {
        FieldType sourceType;
        if (FieldType.COMPLEX.equals((Object)targetType)) {
            return sourceObject;
        }
        Object targetObject = null;
        Object tmpSourceObject = sourceObject;
        FieldType fieldType = sourceType = sourceObject != null ? this.getConversionService().fieldTypeFromClass(sourceObject.getClass()) : FieldType.NONE;
        if (actions == null || actions.getActions() == null || actions.getActions().isEmpty()) {
            if (sourceObject == null) {
                return null;
            }
            return this.getConversionService().convertType(sourceObject, sourceType, targetType);
        }
        FieldType currentType = sourceType;
        for (Action action : actions.getActions()) {
            ActionDetail detail = this.getActionDetailByActionName(action.getClass().getSimpleName());
            if (!detail.getSourceType().equals((Object)currentType) && !FieldType.ALL.equals((Object)detail.getSourceType())) {
                tmpSourceObject = this.getConversionService().convertType(sourceObject, currentType, detail.getSourceType());
            }
            targetObject = this.processAction(action, this.getActionDetailByActionName(action.getClass().getSimpleName()), tmpSourceObject);
            currentType = detail.getTargetType();
        }
        if (currentType != null && !currentType.equals((Object)targetType)) {
            targetObject = this.getConversionService().convertType(targetObject, currentType, targetType);
        }
        return targetObject;
    }

    protected Object processAction(Action action, ActionDetail actionDetail, Object sourceObject) throws AtlasException {
        Object targetObject = null;
        if (actionDetail != null) {
            Object actionObject = null;
            try {
                Class<?> actionClazz = Class.forName(actionDetail.getClassName());
                actionObject = actionClazz.newInstance();
                Method method = null;
                if (actionDetail.getSourceType() != null) {
                    switch (actionDetail.getSourceType()) {
                        case BOOLEAN: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Boolean.class);
                            break;
                        }
                        case BYTE: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Byte.class);
                            break;
                        }
                        case BYTE_ARRAY: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Byte[].class);
                            break;
                        }
                        case CHAR: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Character.class);
                            break;
                        }
                        case DOUBLE: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Double.class);
                            break;
                        }
                        case FLOAT: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Float.class);
                            break;
                        }
                        case INTEGER: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Integer.class);
                            break;
                        }
                        case LONG: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Long.class);
                            break;
                        }
                        case SHORT: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Short.class);
                            break;
                        }
                        case STRING: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, String.class);
                            break;
                        }
                        case ALL: {
                            method = actionClazz.getMethod(actionDetail.getMethod(), Action.class, Object.class);
                            break;
                        }
                        default: {
                            logger.warn(String.format("Unsupported sourceType=%s in actionClass=%s", actionDetail.getSourceType().value(), actionDetail.getClassName()));
                        }
                    }
                }
                if (method == null) {
                    throw new AtlasException(String.format("Unable to locate field action className=%s method=%s sourceType=%s", actionDetail.getClassName(), actionDetail.getMethod(), actionDetail.getSourceType().value()));
                }
                targetObject = Modifier.isStatic(method.getModifiers()) ? method.invoke(null, action, sourceObject) : method.invoke(actionObject, action, sourceObject);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new AtlasException(String.format("Error processing action %s", actionDetail.getName()), (Throwable)e);
            }
            return targetObject;
        }
        return sourceObject;
    }

    protected Properties detectFieldActionParameters(String actionClassName) throws ClassNotFoundException {
        Class<?> actionClazz = Class.forName(actionClassName);
        Properties props = null;
        for (Method method : actionClazz.getMethods()) {
            if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
            if (props == null) {
                props = new Properties();
            }
            Property prop = null;
            for (Parameter param : method.getParameters()) {
                prop = new Property();
                prop.setName(DefaultAtlasFieldActionService.camelize(method.getName().substring("set".length())));
                prop.setFieldType(this.getConversionService().fieldTypeFromClass(param.getType()));
                props.getProperty().add(prop);
            }
        }
        return props;
    }

    public AtlasConversionService getConversionService() {
        return this.conversionService;
    }

    public static String camelize(String parameter) {
        if (parameter == null || parameter.length() == 0) {
            return parameter;
        }
        char[] c = parameter.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }
}

