/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasPropertyStrategy;
import io.atlasmap.spi.AtlasPropertyType;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlasPropertyStrategy
implements AtlasPropertyStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAtlasPropertyStrategy.class);
    private boolean environmentPropertiesEnabled = true;
    private boolean systemPropertiesEnabled = true;
    private boolean mappingDefinedPropertiesEnabled = true;
    private boolean runtimePropertiesEnabled = true;
    private List<AtlasPropertyType> propertyOrder = Arrays.asList(AtlasPropertyType.ENVIRONMENT_VARIABLES, AtlasPropertyType.JAVA_SYSTEM_PROPERTIES, AtlasPropertyType.MAPPING_DEFINED_PROPERTIES, AtlasPropertyType.RUNTIME_PROPERTIES);
    private AtlasConversionService atlasConversionService = null;

    public void processPropertyField(AtlasMapping atlasMapping, PropertyField propertyField, Map<String, Object> runtimeProperties) throws AtlasUnsupportedException, AtlasConversionException {
        if (propertyField == null || propertyField.getName() == null || propertyField.getName().trim().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Null or empty PropertyField specified popertyField=%s", AtlasModelFactory.toString((PropertyField)propertyField)));
            }
            return;
        }
        block6: for (AtlasPropertyType propType : this.getPropertyOrder()) {
            switch (propType) {
                case ENVIRONMENT_VARIABLES: {
                    this.processEnvironmentVariable(propertyField);
                    continue block6;
                }
                case JAVA_SYSTEM_PROPERTIES: {
                    this.processJavaSystemProperty(propertyField);
                    continue block6;
                }
                case MAPPING_DEFINED_PROPERTIES: {
                    this.processMappingDefinedProperties(propertyField, atlasMapping);
                    continue block6;
                }
                case RUNTIME_PROPERTIES: {
                    this.processRuntimeProperties(propertyField, runtimeProperties);
                    continue block6;
                }
            }
            throw new AtlasUnsupportedException(String.format("Unsupported PropertyType detected type=%s for field=%s", propType, AtlasModelFactory.toString((PropertyField)propertyField)));
        }
    }

    protected void processEnvironmentVariable(PropertyField propertyField) {
        if (!this.isEnvironmentPropertiesEnabled()) {
            return;
        }
        try {
            if (System.getenv(propertyField.getName()) != null) {
                propertyField.setValue((Object)System.getenv(propertyField.getName()));
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Assigned environment variable for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                }
            }
        }
        catch (SecurityException e) {
            logger.error(String.format("SecurityException while processing environment variable for propertyField=%s", AtlasModelFactory.toString((PropertyField)propertyField)), (Throwable)e);
        }
    }

    protected void processJavaSystemProperty(PropertyField propertyField) {
        if (!this.isSystemPropertiesEnabled()) {
            return;
        }
        try {
            if (System.getProperty(propertyField.getName()) != null) {
                propertyField.setValue((Object)System.getProperty(propertyField.getName()));
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Assigned Java system property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                }
            }
        }
        catch (SecurityException e) {
            logger.error(String.format("SecurityException while processing Java system property for propertyField=%s", AtlasModelFactory.toString((PropertyField)propertyField)), (Throwable)e);
        }
    }

    protected void processMappingDefinedProperties(PropertyField propertyField, AtlasMapping atlasMapping) throws AtlasConversionException {
        if (!this.isMappingDefinedPropertiesEnabled()) {
            return;
        }
        if (atlasMapping == null || atlasMapping.getProperties() == null || atlasMapping.getProperties().getProperty() == null || atlasMapping.getProperties().getProperty().isEmpty()) {
            return;
        }
        for (Property prop : atlasMapping.getProperties().getProperty()) {
            if (!propertyField.getName().equals(prop.getName())) continue;
            if (this.getAtlasConversionService() != null && (propertyField.getFieldType() != null || prop.getFieldType() != null)) {
                propertyField.setValue(this.getAtlasConversionService().convertType((Object)prop.getValue(), FieldType.STRING, propertyField.getFieldType() != null ? propertyField.getFieldType() : prop.getFieldType()));
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Assigned Mapping defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                }
                return;
            }
            propertyField.setValue((Object)prop.getValue());
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Assigned Mapping defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
            }
            return;
        }
    }

    protected void processRuntimeProperties(PropertyField propertyField, Map<String, Object> runtimeProperties) throws AtlasConversionException {
        if (!this.isRuntimePropertiesEnabled()) {
            return;
        }
        if (runtimeProperties == null || runtimeProperties.isEmpty()) {
            return;
        }
        for (String key : runtimeProperties.keySet()) {
            if (!propertyField.getName().equals(key)) continue;
            if (this.getAtlasConversionService() != null && propertyField.getFieldType() != null) {
                propertyField.setValue(this.getAtlasConversionService().convertType(runtimeProperties.get(key), this.getAtlasConversionService().fieldTypeFromClass(runtimeProperties.get(key).getClass()), propertyField.getFieldType()));
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Assigned Runtime defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
                }
                return;
            }
            propertyField.setValue(runtimeProperties.get(key));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Assigned Runtime defined property for property field name=%s value=%s", propertyField.getName(), propertyField.getValue()));
            }
            return;
        }
    }

    public void setPropertyOrderValue(List<String> propertyValues) {
        LinkedList<AtlasPropertyType> tmp = null;
        for (String v : propertyValues) {
            if (tmp == null) {
                tmp = new LinkedList<AtlasPropertyType>();
            }
            try {
                tmp.add(AtlasPropertyType.fromValue((String)v));
            }
            catch (IllegalArgumentException e) {
                logger.error(String.format("Invalid AtlasPropertyType specified '%s'", v));
            }
        }
        this.propertyOrder = null;
        this.propertyOrder = tmp;
    }

    public boolean isEnvironmentPropertiesEnabled() {
        return this.environmentPropertiesEnabled;
    }

    public void setEnvironmentPropertiesEnabled(boolean environmentPropertiesEnabled) {
        this.environmentPropertiesEnabled = environmentPropertiesEnabled;
    }

    public boolean isSystemPropertiesEnabled() {
        return this.systemPropertiesEnabled;
    }

    public void setSystemPropertiesEnabled(boolean systemPropertiesEnabled) {
        this.systemPropertiesEnabled = systemPropertiesEnabled;
    }

    public boolean isMappingDefinedPropertiesEnabled() {
        return this.mappingDefinedPropertiesEnabled;
    }

    public void setMappingDefinedPropertiesEnabled(boolean mappingDefinedPropertiesEnabled) {
        this.mappingDefinedPropertiesEnabled = mappingDefinedPropertiesEnabled;
    }

    public boolean isRuntimePropertiesEnabled() {
        return this.runtimePropertiesEnabled;
    }

    public void setRuntimePropertiesEnabled(boolean runtimePropertiesEnabled) {
        this.runtimePropertiesEnabled = runtimePropertiesEnabled;
    }

    public List<AtlasPropertyType> getPropertyOrder() {
        return this.propertyOrder;
    }

    public void setPropertyOrder(List<AtlasPropertyType> propertyOrder) {
        this.propertyOrder = propertyOrder;
    }

    public AtlasConversionService getAtlasConversionService() {
        return this.atlasConversionService;
    }

    public void setAtlasConversionService(AtlasConversionService atlasConversionService) {
        this.atlasConversionService = atlasConversionService;
    }
}

