/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Validations;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultAtlasSession
implements AtlasSession {
    private AtlasContext atlasContext;
    private final AtlasMapping mapping;
    private Audits audits;
    private Validations validations;
    private Map<String, Object> properties;
    private Map<String, Object> inputMap = new HashMap<String, Object>();
    private Map<String, Object> outputMap = new HashMap<String, Object>();

    public DefaultAtlasSession(AtlasMapping mapping) {
        this.initialize();
        this.mapping = mapping;
    }

    protected void initialize() {
        this.properties = new ConcurrentHashMap<String, Object>();
        this.validations = new Validations();
        this.audits = new Audits();
    }

    public AtlasContext getAtlasContext() {
        return this.atlasContext;
    }

    public void setAtlasContext(AtlasContext atlasContext) {
        this.atlasContext = atlasContext;
    }

    public AtlasMapping getMapping() {
        return this.mapping;
    }

    public Validations getValidations() {
        return this.validations;
    }

    public void setValidations(Validations validations) {
        this.validations = validations;
    }

    public Audits getAudits() {
        return this.audits;
    }

    public void setAudits(Audits audits) {
        this.audits = audits;
    }

    public Object getInput() {
        return this.inputMap.get("ATLAS_SOURCE_DOC");
    }

    public Object getInput(String docId) {
        return this.inputMap.get(docId);
    }

    public boolean hasInput(String docId) {
        return this.inputMap.containsKey(docId);
    }

    public Map<String, Object> getInputMap() {
        return Collections.unmodifiableMap(this.inputMap);
    }

    public Object getOutput() {
        return this.outputMap.get("ATLAS_TARGET_DOC");
    }

    public Object getOutput(String docId) {
        return this.outputMap.get(docId);
    }

    public boolean hasOutput(String docId) {
        return this.outputMap.containsKey(docId);
    }

    public Map<String, Object> getOutputMap() {
        return Collections.unmodifiableMap(this.outputMap);
    }

    public void setInput(Object input) {
        this.inputMap.put("ATLAS_SOURCE_DOC", input);
    }

    public void setInput(Object inputObject, String docId) {
        this.inputMap.put(docId, inputObject);
    }

    public void setOutput(Object output) {
        this.outputMap.put("ATLAS_TARGET_DOC", output);
    }

    public void setOutput(Object outputObject, String docId) {
        this.outputMap.put(docId, outputObject);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Integer errorCount() {
        int e = 0;
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.ERROR.equals((Object)audit.getStatus())) continue;
            ++e;
        }
        return e;
    }

    public boolean hasErrors() {
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.ERROR.equals((Object)audit.getStatus())) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarns() {
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.WARN.equals((Object)audit.getStatus())) continue;
            return true;
        }
        return false;
    }

    public Integer warnCount() {
        int w = 0;
        for (Audit audit : this.getAudits().getAudit()) {
            if (!AuditStatus.WARN.equals((Object)audit.getStatus())) continue;
            ++w;
        }
        return w;
    }
}

