/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasValidationService;
import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.LookupTables;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.CompositeValidator;
import io.atlasmap.validators.LookupTableNameValidator;
import io.atlasmap.validators.NonNullValidator;
import io.atlasmap.validators.NotEmptyValidator;
import io.atlasmap.validators.PositiveIntegerValidator;
import io.atlasmap.validators.StringPatternValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultAtlasValidationService
implements AtlasValidationService {
    public List<Validation> validateMapping(AtlasMapping mapping) {
        ArrayList<Validation> validations = new ArrayList<Validation>();
        Validators.MAPPING_NAME.get().validate((Object)mapping.getName(), validations);
        List dataSources = mapping.getDataSource();
        for (DataSource ds : dataSources) {
            switch (ds.getDataSourceType()) {
                case SOURCE: {
                    Validators.DATASOURCE_SOURCE_URI.get().validate((Object)ds.getUri(), validations);
                    break;
                }
                case TARGET: {
                    Validators.DATASOURCE_TARGET_URI.get().validate((Object)ds.getUri(), validations);
                }
            }
        }
        this.validateFieldMappings(mapping.getMappings(), mapping.getLookupTables(), validations);
        return validations;
    }

    private void validateFieldMappings(Mappings mappings, LookupTables lookupTables, List<Validation> validations) {
        Validators.FIELD_NAMES_NOT_NULL.get().validate((Object)mappings, validations);
        if (mappings != null) {
            Validators.FIELD_NAMES_NOT_EMPTY.get().validate((Object)mappings, validations, ValidationStatus.WARN);
            List fieldMappings = mappings.getMapping();
            if (fieldMappings != null && !fieldMappings.isEmpty()) {
                List<Mapping> mapFieldMappings = fieldMappings.stream().filter(p -> p.getMappingType() == MappingType.MAP).map(p -> (Mapping)p).collect(Collectors.toList());
                List<Mapping> combineFieldMappings = fieldMappings.stream().filter(p -> p.getMappingType() == MappingType.COMBINE).map(p -> (Mapping)p).collect(Collectors.toList());
                List<Mapping> separateFieldMappings = fieldMappings.stream().filter(p -> p.getMappingType() == MappingType.SEPARATE).map(p -> (Mapping)p).collect(Collectors.toList());
                List<Mapping> lookupFieldMappings = fieldMappings.stream().filter(p -> p.getMappingType() == MappingType.LOOKUP).map(p -> (Mapping)p).collect(Collectors.toList());
                this.validateMapMapping(mapFieldMappings, validations);
                this.validateCombineMapping(combineFieldMappings, validations);
                this.validateSeparateMapping(separateFieldMappings, validations);
                this.validateLookupTables(lookupFieldMappings, lookupTables, validations);
            }
        }
    }

    private void validateLookupTables(List<Mapping> lookupFieldMappings, LookupTables lookupTables, List<Validation> validations) {
        if (lookupTables != null && lookupTables.getLookupTable() != null && !lookupTables.getLookupTable().isEmpty()) {
            Validators.LOOKUPTABLE_NAME_CHECK_FOR_DUPLICATE.get().validate((Object)lookupTables, validations);
            if (lookupFieldMappings.isEmpty()) {
                Validation validation = new Validation();
                validation.setField("lookup.fields.missing");
                validation.setMessage("LookupTables are defined but no LookupFields are utilized.");
                validation.setStatus(ValidationStatus.WARN);
                validations.add(validation);
            } else {
                this.validateLookupFieldMapping(lookupFieldMappings, lookupTables, validations);
            }
        }
    }

    private void validateLookupFieldMapping(List<Mapping> fieldMappings, LookupTables lookupTables, List<Validation> validations) {
        Set disjoint;
        Set lookupFieldMappingTableNameRefs = fieldMappings.stream().map(Mapping::getLookupTableName).collect(Collectors.toSet());
        Set tableNames = lookupTables.getLookupTable().stream().map(LookupTable::getName).collect(Collectors.toSet());
        if (!(lookupFieldMappingTableNameRefs.isEmpty() || tableNames.isEmpty() || (disjoint = Stream.concat(lookupFieldMappingTableNameRefs.stream(), tableNames.stream()).collect(Collectors.toMap(Function.identity(), t -> true, (a, b) -> null)).keySet()).isEmpty())) {
            Validation validation;
            boolean isInTableNameList;
            boolean isInFieldList = !lookupFieldMappingTableNameRefs.stream().filter(disjoint::contains).collect(Collectors.toList()).isEmpty();
            boolean bl = isInTableNameList = !tableNames.stream().filter(disjoint::contains).collect(Collectors.toList()).isEmpty();
            if (isInFieldList) {
                validation = new Validation();
                validation.setField("lookupfield.tablename");
                validation.setMessage("One ore more LookupFieldMapping references a non existent LookupTable name in the mapping");
                validation.setStatus(ValidationStatus.ERROR);
                validation.setValue(disjoint.toString());
                validations.add(validation);
            }
            if (isInTableNameList) {
                validation = new Validation();
                validation.setField("lookupfield.tablename");
                validation.setMessage("A LookupTable is defined but not used by any LookupField");
                validation.setStatus(ValidationStatus.WARN);
                validation.setValue(disjoint.toString());
                validations.add(validation);
            }
        }
        for (Mapping fieldMapping : fieldMappings) {
            if (fieldMapping.getInputField() != null) {
                Validators.MAP_INPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getInputField(), validations);
            }
            Validators.MAP_OUTPUT_NOT_NULL.get().validate((Object)fieldMapping.getOutputField(), validations, ValidationStatus.WARN);
            if (fieldMapping.getOutputField() == null) continue;
            Validators.MAP_OUTPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getOutputField(), validations, ValidationStatus.WARN);
        }
    }

    private void validateMapMapping(List<Mapping> fieldMappings, List<Validation> validations) {
        for (Mapping fieldMapping : fieldMappings) {
            Validators.MAP_INPUT_NOT_NULL.get().validate((Object)fieldMapping.getInputField(), validations);
            if (fieldMapping.getInputField() != null) {
                Validators.MAP_INPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getInputField(), validations);
            }
            Validators.MAP_OUTPUT_NOT_NULL.get().validate((Object)fieldMapping.getOutputField(), validations, ValidationStatus.WARN);
            if (fieldMapping.getOutputField() == null) continue;
            Validators.MAP_OUTPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getOutputField(), validations, ValidationStatus.WARN);
        }
    }

    private void validateSeparateMapping(List<Mapping> fieldMappings, List<Validation> validations) {
        for (Mapping fieldMapping : fieldMappings) {
            Validators.SEPARATE_INPUT_NOT_NULL.get().validate((Object)fieldMapping.getInputField(), validations);
            if (fieldMapping.getInputField() != null) {
                Validators.SEPARATE_INPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getInputField(), validations);
            }
            Validators.SEPARATE_OUTPUT_NOT_NULL.get().validate((Object)fieldMapping.getOutputField(), validations, ValidationStatus.WARN);
            Validators.SEPARATE_OUTPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getOutputField(), validations, ValidationStatus.WARN);
            if (fieldMapping.getOutputField() == null) continue;
            for (Field field : fieldMapping.getOutputField()) {
                Validators.SEPARATE_OUTPUT_FIELD_NOT_NULL.get().validate((Object)field, validations);
                if (field.getIndex() != null && field.getIndex() >= 0) continue;
                Validators.SEPARATE_OUTPUT_FIELD_FIELD_ACTION_INDEX_POSITIVE.get().validate((Object)field.getIndex(), validations);
            }
        }
    }

    private void validateCombineMapping(List<Mapping> fieldMappings, List<Validation> validations) {
        for (Mapping fieldMapping : fieldMappings) {
            Validators.COMBINE_OUTPUT_NOT_NULL.get().validate((Object)fieldMapping.getOutputField(), validations);
            if (fieldMapping.getOutputField() != null) {
                Validators.COMBINE_OUTPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getOutputField(), validations);
            }
            Validators.COMBINE_INPUT_NOT_NULL.get().validate((Object)fieldMapping.getInputField(), validations, ValidationStatus.WARN);
            Validators.COMBINE_INPUT_FIELD_NOT_EMPTY.get().validate((Object)fieldMapping.getInputField(), validations, ValidationStatus.WARN);
            if (fieldMapping.getInputField() == null) continue;
            for (Field field : fieldMapping.getInputField()) {
                Validators.COMBINE_INPUT_FIELD_NOT_NULL.get().validate((Object)field, validations);
                if (field.getIndex() != null && field.getIndex() >= 0) continue;
                Validators.COMBINE_INPUT_FIELD_FIELD_ACTION_INDEX_POSITIVE.get().validate((Object)field.getIndex(), validations);
            }
        }
    }

    static enum Validators {
        MAPPING_NAME(() -> {
            StringPatternValidator namePattern = new StringPatternValidator("Mapping.Name", "Mapping name must not contain spaces nor special characters other than period (.) and underscore (_)", "[^A-Za-z0-9_.]");
            NonNullValidator nameNotNull = new NonNullValidator("Mapping.Name", "Mapping name must not be null nor empty");
            return new CompositeValidator(namePattern, nameNotNull);
        }),
        DATASOURCE_TARGET_URI(() -> new NonNullValidator("DataSource.target.uri", "DataSource target uri must not be null nor empty")),
        DATASOURCE_SOURCE_URI(() -> new NonNullValidator("DataSource.source.uri", "DataSource source uri must not be null nor empty")),
        FIELD_NAMES_NOT_EMPTY(() -> new NotEmptyValidator("Field.Mappings", "Field mappings should not be empty")),
        FIELD_NAMES_NOT_NULL(() -> new NonNullValidator("Field.Mappings", "Field mappings must not be null")),
        COMBINE_INPUT_NOT_NULL(() -> new NonNullValidator("CombineFieldMapping.Input", "Input element should not be null")),
        COMBINE_INPUT_FIELD_NOT_EMPTY(() -> new NotEmptyValidator("CombineFieldMapping.Input.Field", "Input field element should not be empty")),
        COMBINE_OUTPUT_NOT_NULL(() -> new NonNullValidator("CombineFieldMapping.Output", "Output element must not be null")),
        COMBINE_OUTPUT_FIELD_NOT_EMPTY(() -> new NotEmptyValidator("CombineFieldMapping.Output.Field", "Output field element must not be empty")),
        COMBINE_INPUT_FIELD_NOT_NULL(() -> new NonNullValidator("CombineFieldMapping.Input.Fields", "Input field elements should not be null")),
        COMBINE_INPUT_FIELD_FIELD_ACTION_INDEX_POSITIVE(() -> new PositiveIntegerValidator("CombineFieldMapping.Input.Fields.FieldActions.MapAction.Index", "MapAction index must exists and be greater than or equal to zero (0)")),
        MAP_INPUT_NOT_NULL(() -> new NonNullValidator("MapFieldMapping.Input", "Input element must not be null")),
        MAP_INPUT_FIELD_NOT_EMPTY(() -> new NotEmptyValidator("MapFieldMapping.Input.Field", "Input field element must not be empty")),
        MAP_OUTPUT_NOT_NULL(() -> new NonNullValidator("MapFieldMapping.Output", "Output element should not be null")),
        MAP_OUTPUT_FIELD_NOT_EMPTY(() -> new NotEmptyValidator("MapFieldMapping.Output.Field", "Output field element should not be empty")),
        SEPARATE_INPUT_NOT_NULL(() -> new NonNullValidator("SeparateFieldMapping.Input", "Input element must not be null")),
        SEPARATE_INPUT_FIELD_NOT_NULL(() -> new NonNullValidator("SeparateFieldMapping.Input.Field", "Input field element must not be null")),
        SEPARATE_INPUT_FIELD_NOT_EMPTY(() -> new NotEmptyValidator("SeparateFieldMapping.Input.Field", "Input field element must not be empty")),
        SEPARATE_OUTPUT_NOT_NULL(() -> new NonNullValidator("SeparateFieldMapping.Output", "Output element should not be null")),
        SEPARATE_OUTPUT_FIELD_NOT_NULL(() -> new NonNullValidator("SeparateFieldMapping.Output.Fields", "Output field elements should not be null")),
        SEPARATE_OUTPUT_FIELD_NOT_EMPTY(() -> new NotEmptyValidator("SeparateFieldMapping.Output.Fields", "Output field elements should not be empty")),
        SEPARATE_OUTPUT_FIELD_FIELD_ACTION_NOT_EMPTY(() -> new NotEmptyValidator("SeparateFieldMapping.Output.FieldActions", "Field actions cannot be null or empty")),
        SEPARATE_OUTPUT_FIELD_FIELD_ACTION_INDEX_POSITIVE(() -> new PositiveIntegerValidator("SeparateFieldMapping.Output.Fields.FieldActions.MapAction.Index", "MapAction index must exists and be greater than or equal to zero (0)")),
        LOOKUPTABLE_NAME_CHECK_FOR_DUPLICATE(() -> new LookupTableNameValidator("lookuptables.lookuptable.name", "LookupTables contain duplicated LookupTable names."));

        private final AtlasValidator validator;

        private Validators(Supplier<AtlasValidator> s) {
            this.validator = s.get();
        }

        public AtlasValidator get() {
            return this.validator;
        }
    }
}

