/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;

public class NonNullValidator
implements AtlasValidator {
    private String violationMessage;
    private String field;

    public NonNullValidator(String field, String violationMessage) {
        this.field = field;
        this.violationMessage = violationMessage;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public void validate(Object target, List<Validation> validations) {
        this.validate(target, validations, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, ValidationStatus status) {
        String value;
        if (target == null) {
            Validation validation = new Validation();
            validation.setField(this.field);
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validations.add(validation);
        } else if (target.getClass().isAssignableFrom(String.class) && (value = (String)target).trim().isEmpty()) {
            Validation validation = new Validation();
            validation.setField(this.field);
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validation.setValue(target.toString());
            validations.add(validation);
        }
    }
}

