/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NotEmptyValidator
implements AtlasValidator {
    private String violationMessage;
    private String field;

    public NotEmptyValidator(String field, String violationMessage) {
        this.violationMessage = violationMessage;
        this.field = field;
    }

    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(List.class) || clazz.isAssignableFrom(Map.class) || clazz.isAssignableFrom(Set.class) || clazz.isAssignableFrom(Collection.class);
    }

    public boolean supports(Object object) {
        return object instanceof List || object instanceof Map || object instanceof Set || object instanceof Collection;
    }

    public void validate(Object target, List<Validation> validations) {
        this.validate(target, validations, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, ValidationStatus status) {
        if (!this.supports(target)) {
            return;
        }
        if (((Collection)target).isEmpty()) {
            Validation validation = new Validation();
            validation.setField(this.field);
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validation.setValue(target.toString());
            validations.add(validation);
        }
    }
}

