/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;

public class PositiveIntegerValidator
implements AtlasValidator {
    private String violationMessage;
    private String field;

    public PositiveIntegerValidator(String field, String violationMessage) {
        this.violationMessage = violationMessage;
        this.field = field;
    }

    public boolean supports(Class<?> clazz) {
        return Integer.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, List<Validation> validations) {
        this.validate(target, validations, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, ValidationStatus status) {
        Integer value = (Integer)target;
        if (value == null || value < 0) {
            Validation validation = new Validation();
            validation.setField(this.field);
            validation.setValue(target != null ? target.toString() : null);
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validations.add(validation);
        }
    }
}

