/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;

public class StringLengthValidator
implements AtlasValidator {
    private String violationMessage;
    private int minLength = 1;
    private int maxLength = Integer.MAX_VALUE;
    private String field;

    public StringLengthValidator(String field, String violationMessage, int minLength, int maxLength) {
        this.field = field;
        this.violationMessage = violationMessage;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    public boolean supports(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, List<Validation> validations) {
        this.validate(target, validations, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, ValidationStatus status) {
        String value = (String)target;
        if (value.isEmpty() || value.length() > this.maxLength || value.length() < this.minLength) {
            Validation validation = new Validation();
            validation.setField(this.field);
            validation.setValue(target.toString());
            validation.setMessage(this.violationMessage);
            validation.setStatus(status);
            validations.add(validation);
        }
    }
}

