/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringPatternValidator
implements AtlasValidator {
    private String violationMessage;
    private String pattern;
    private String field;
    private boolean useMatch;

    public StringPatternValidator(String field, String violationMessage, String pattern) {
        this(field, violationMessage, pattern, false);
    }

    public StringPatternValidator(String field, String violationMessage, String pattern, boolean useMatch) {
        this.violationMessage = violationMessage;
        this.pattern = pattern;
        this.field = field;
        this.useMatch = useMatch;
    }

    public boolean supports(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, List<Validation> validations) {
        this.validate(target, validations, ValidationStatus.ERROR);
    }

    public void validate(Object target, List<Validation> validations, ValidationStatus status) {
        Pattern regEx = Pattern.compile(this.pattern);
        if (target != null && this.supports(target.getClass())) {
            String value = (String)target;
            Matcher m = regEx.matcher(value);
            if (this.useMatch) {
                if (!m.matches()) {
                    Validation validation = new Validation();
                    validation.setField(this.field);
                    validation.setValue(target.toString());
                    validation.setMessage(this.violationMessage);
                    validation.setStatus(status);
                    validations.add(validation);
                }
            } else if (m.find()) {
                Validation validation = new Validation();
                validation.setField(this.field);
                validation.setValue(target.toString());
                validation.setMessage(this.violationMessage);
                validation.setStatus(status);
                validations.add(validation);
            }
        }
    }
}

