/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class ByteConverter
implements AtlasPrimitiveConverter<Byte> {
    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean convertToBoolean(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value != 0;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.BYTE)
    public Byte convertToByte(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return new Byte(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.CHAR)
    public Character convertToCharacter(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Character.valueOf((char)value.byteValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (double)value;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.FLOAT)
    public Float convertToFloat(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.byteValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.INTEGER)
    public Integer convertToInteger(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (int)value;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.LONG)
    public Long convertToLong(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (long)value;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.SHORT)
    public Short convertToShort(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (short)value;
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.STRING, concerns={AtlasConversionConcern.CONVENTION})
    public String convertToString(Byte value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @AtlasConversionInfo(sourceType=FieldType.BYTE, targetType=FieldType.NUMBER)
    public Number convertToNumber(Byte value) throws AtlasConversionException {
        return this.convertToShort(value);
    }
}

