/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class CharacterConverter
implements AtlasPrimitiveConverter<Character> {
    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean convertToBoolean(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.charValue() == '1' || value.charValue() == '0' || value.charValue() == 'T' || value.charValue() == 'F' || value.charValue() == 't' || value.charValue() == 'f') {
            if (value.charValue() == '1' || value.charValue() == 't' || value.charValue() == 'T') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return value.charValue() != '\u0000';
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte convertToByte(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.charValue() > '\u007f') {
            throw new AtlasConversionException(String.format("Character value %s is greater than BYTE.MAX_VALUE", Character.valueOf(value.charValue())));
        }
        return (byte)value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.CHAR)
    public Character convertToCharacter(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return new Character(value.charValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.FLOAT)
    public Float convertToFloat(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.charValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.INTEGER)
    public Integer convertToInteger(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.LONG)
    public Long convertToLong(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Short convertToShort(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value.charValue() > Short.MAX_VALUE) {
            throw new AtlasConversionException();
        }
        return (short)value.charValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.CHAR, targetType=FieldType.STRING)
    public String convertToString(Character value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

