/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasUnsupportedException;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasPrimitiveConverter;
import io.atlasmap.v2.FieldType;

public class IntegerConverter
implements AtlasPrimitiveConverter<Integer> {
    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.BOOLEAN, concerns={AtlasConversionConcern.CONVENTION})
    public Boolean convertToBoolean(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.BYTE, concerns={AtlasConversionConcern.RANGE})
    public Byte convertToByte(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value >= -128 && value <= 127) {
            return value.byteValue();
        }
        throw new AtlasConversionException((Throwable)new AtlasUnsupportedException(String.format("Integer %s is greater than Byte.MAX_VALUE or less than Byte.MIN_VALUE", value)));
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.CHAR, concerns={AtlasConversionConcern.RANGE, AtlasConversionConcern.CONVENTION})
    public Character convertToCharacter(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value < 0 || value > 65535) {
            throw new AtlasConversionException(String.format("Integer %s is greater than Character.MAX_VALUE or less than Character.MIN_VALUE", value));
        }
        return Character.valueOf((char)value.intValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.DOUBLE)
    public Double convertToDouble(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.doubleValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.FLOAT, concerns={AtlasConversionConcern.RANGE})
    public Float convertToFloat(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.INTEGER)
    public Integer convertToInteger(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return (int)value;
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.LONG)
    public Long convertToLong(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return value.longValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.SHORT, concerns={AtlasConversionConcern.RANGE})
    public Short convertToShort(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new AtlasConversionException(String.format("Integer %s is greater than Short.MAX_VALUE or less than Short.MIN_VALUE", value));
        }
        return value.shortValue();
    }

    @AtlasConversionInfo(sourceType=FieldType.INTEGER, targetType=FieldType.STRING)
    public String convertToString(Integer value) throws AtlasConversionException {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }
}

